/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#include "Button.h"
#include "mbed.h"
#include "DMBoard.h"

#include "lpc_swim_font.h"

Button::Button(const char* caption, COLOR_T* fb, uint16_t x, uint16_t y, uint16_t width, uint16_t height) :
  Clickable(fb, x, y, width, height),
  _caption(caption), _capx(0), _capy(0), 
  _bgCol(GREEN), _fgCol(BLACK), 
  _bgColPressed(BLACK), _fgColPressed(GREEN)
{
  swim_set_font_transparency(&_win, 1);
  setCaption(caption);
}

void Button::setCaption(const char* caption)
{
  int w, h;
  _caption = caption;
  swim_get_string_bounds(&_win, _caption, &w, &h);
  _capx = (_win.xpmax-_win.xpmin-w)/2;
  _capy = (_win.ypmax-_win.ypmin-h)/2;
}

void Button::setColors(COLOR_T bg, COLOR_T fg, COLOR_T bgPressed, COLOR_T fgPressed)
{
  _bgCol = bg;
  _fgCol = fg;
  _bgColPressed = bgPressed;
  _fgColPressed = fgPressed;
}

void Button::draw(COLOR_T* fb)
{
  if (fb != NULL) {
    _win.fb = fb;
  }
  if (_pressed) {
    swim_set_pen_color(&_win, _fgColPressed);
    swim_set_bkg_color(&_win, _bgColPressed);
    swim_set_fill_color(&_win, _fgColPressed);
    swim_clear_screen(&_win, _bgColPressed);
  } else {
    swim_set_pen_color(&_win, _fgCol);
    swim_set_bkg_color(&_win, _bgCol);
    swim_set_fill_color(&_win, _fgCol);
    swim_clear_screen(&_win, _bgCol);
  }
  swim_put_text_xy(&_win, _caption, _capx, _capy);
}
