#include "mbed.h"
#include "data_models.h"


Serial pc(USBTX, USBRX);
DigitalIn din(p20);

void serialInit(void){

    pc.baud(115200);
    pc.format(8, Serial::None, 1);
     
}

void sendPayload(Payload *data){

    uint8_t *d=(uint8_t *)&data->ftype;
    
    for(uint8_t i=0 ; i<(sizeof(Frame)+sizeof(Ftype)) ; i++){
    
       if(d[i]==0x0A)   pc.putc(0x0D); //add CR LF
        pc.putc(d[i]);
        
    }
}

int main() {

    din.mode(PullUp);
    
    serialInit();
    
    Payload payload;
    
    initTestPayloadData(&payload);
    payloadToNetwork(&payload);
    
    while(1) {
 //       if(!din){
            sendPayload(&payload);
            wait(0.2);
//         } 
    }
}
