#include "mbed.h"
#include "leds.h"

Timeout led_ether;
Timeout led_xbee;
Timeout led_device;

DigitalOut ledXb(LED1);
DigitalOut ledDev(LED2);
DigitalOut ledTcpCon(LED3);
DigitalOut ledEt(LED4);

void offEther(void){
    ledEt=0;
}
void offXBee(void){
    ledXb=0;
}
void offDevice(void){
    ledDev=0;
}

void ledEther(void)
{
    ledEt=1;
    led_ether.attach(&offEther,kLedOnTime);
}
void ledXBee(void)
{
    ledXb=1;
    led_xbee.attach(&offXBee,kLedOnTime);
}
void ledDevice(void)
{
    ledDev=1;
    led_device.attach(&offDevice,kLedOnTime);
}
void onLedDevice(void)
{
    ledDev=1;
}

void ledTcpConnect(bool isConnect)
{
    if(isConnect)   ledTcpCon=1;
    else            ledTcpCon=0;
}