#include "types.h"
#include "data_models.h"
#include "EthernetNetIf.h"

extern Serial pc;


void initPayload(Payload *_payload)
{
    _payload->size=sizeof(Payload);
    _payload->dummy = 0;
    _payload->ftype = Ftype_Type_B;
    
    Frame *frame=&_payload->frame;
    
    for(int i=0 ; i < sizeof(frame->id.personalId) ; i++) frame->id.personalId[i]=0;
    
    frame->message.frameNumber=0xFFFF;
    frame->message.device=SERVER;
    frame->message.command=PING;
    
    for(int i=0 ; i < sizeof(_payload->frame.message.data) ; i++) _payload->frame.message.data[i]=0;
}

void payloadToNetwork(Payload *_payload)
{
    Frame *frame=&_payload->frame;
    _payload->size               = htons(_payload->size);
//    frame->id.head               = htons(frame->id.head);
    frame->message.totalSize     = htons(frame->message.totalSize);
    frame->message.frameNumber   = htons(frame->message.frameNumber);
    frame->message.sum           = htons(frame->message.sum);
    
    if(frame->message.command == PING) {
    
    if(frame->message.device == SERVER)
    {
    
        PrefServer *data;
        data =  (PrefServer*)frame->message.data;
        data->serverPort = htons(data->serverPort);
        data->destinationPort = htons(data->destinationPort);
        data->xbeeAdress = htonl(data->xbeeAdress);

    }
    else if(frame->message.device == LED_SENDER)
    {
        PrefSender *data;
        data =  (PrefSender*)frame->message.data;
        data->xbeeAdress = htonl(data->xbeeAdress);
        data->currentFrameNumber = htons(data->currentFrameNumber);
    }
    else if(frame->message.device == LED_RECIEVER)
    {
        PrefReciever *data;
        data =  (PrefReciever*)frame->message.data;
        data->xbeeAdress = htonl(data->xbeeAdress);
    }
    }
      
}
void networkToPayload(Payload *_payload)
{
    Frame *frame=&_payload->frame;
    _payload->size               = ntohs(_payload->size);
//    frame->id.head               = ntohs(frame->id.head);
    frame->message.totalSize     = ntohs(frame->message.totalSize);
    frame->message.frameNumber   = ntohs(frame->message.frameNumber);
    frame->message.sum           = ntohs(frame->message.sum); 
    
    if(frame->message.command == PING){
    
    if(frame->message.device == SERVER)
    {      
        PrefServer *data;
        data =  (PrefServer*)frame->message.data;
        data->serverPort = ntohs(data->serverPort);
        data->destinationPort = ntohs(data->destinationPort);
        data->xbeeAdress = ntohl(data->xbeeAdress);
    }
    else if(frame->message.device == LED_SENDER)
    {
        PrefSender *data;
        data =  (PrefSender*)frame->message.data;
        data->xbeeAdress = ntohl(data->xbeeAdress);
        data->currentFrameNumber = ntohs(data->currentFrameNumber);
    }
    else if(frame->message.device == LED_RECIEVER)
    {
        PrefReciever *data;
        data =  (PrefReciever*)frame->message.data;
        data->xbeeAdress = ntohl(data->xbeeAdress);
    }
    }
}



void initTestPayloadData(Payload *_payload)
{
   Frame *frame=&_payload->frame;
   
   initPayload(_payload);
   _payload->size=sizeof(Payload);
   
//   frame->id.head=0x0000;
//   uint8_t tmpid[14]={0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x40,0x41,0x42,0x43,0x44};
   uint8_t tmpid[16]={0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x40,0x41,0x42,0x43,0x44,0x45,0x46};
   for(int i=0;i<sizeof(tmpid);i++) frame->id.personalId[i]=tmpid[i];
   
   
   frame->message.frameNumber=1;
   frame->message.device=LED_SENDER;
   frame->message.command=SEND_SINGLE;
   
   uint8_t tmpdata[40]={
    1,2,3,4,5,6,7,8,9,10,
    11,12,13,14,15,16,17,18,19,20,
    21,22,23,24,25,26,27,28,29,30,
    31,32,33,34,35,36,37,38,39,40};
   for(int i=0;i<sizeof(tmpdata);i++) frame->message.data[i]=tmpdata[i];
   
   frame->message.totalSize=
     sizeof(frame->message.totalSize)
    +sizeof(frame->message.frameNumber)
    +sizeof(frame->message.device)
    +sizeof(frame->message.command)
    +sizeof(frame->message.data);
    
    uint16_t sum = culcSum(_payload);
    
    frame->message.sum = sum;

}

uint16_t culcSum(Payload *_payload){

    uint16_t tmpSum = _payload->ftype;
    uint8_t *data = (uint8_t *)&_payload->frame;
    
    for(uint8_t i=0 ; i<sizeof(Frame)-2 ; i++){
        tmpSum += data[i];
    }
    return tmpSum;
}

void dumpPayload(Payload *_payload)
{
    Frame *frame=&_payload->frame;
    pc.printf("\r\n======== dump!!\r\n");
    pc.printf("payload\nsize:%04X\r\n ",_payload->size);
    pc.printf("Type:%0X\r\n ",_payload->ftype);
    
//    pc.printf("Payload id_head:%04X\r\n personal id:",_payload->frame.id.head);
    pc.printf("personal id:");  
    for(int i=0 ; i < sizeof(frame->id.personalId) ; i++){
        pc.printf("%02X:%c ",frame->id.personalId[i],frame->id.personalId[i]);
    }
    
    pc.printf("\r\n");
    
    pc.printf("total size:%d , frame number:%d , divece:%0X , command:%02X , sum:%04X\r\n"
        ,frame->message.totalSize
        ,frame->message.frameNumber
        ,frame->message.device
        ,frame->message.command
        ,frame->message.sum);
    
    pc.printf("message data:\r\n");
    for(int i=0 ; i < sizeof(frame->message.data) ; i++){
         pc.printf("%d:%02X ",i,_payload->frame.message.data[i]);
    }
    
    pc.printf("\r\n--- RAW DATA -------\r\n");
    for(int i=0 ; i < sizeof(Payload) ; i++){
         pc.printf("%d:%02X ",i,((uint8_t*)_payload)[i]);
    }
    pc.printf("\r\n");
    
}

void dumpPrefSender(PrefSender *prf)
{
    pc.printf("current frame number:%d\n",prf->currentFrameNumber);
    pc.printf("gainData gain:%d\n",prf->gainData.gain);
    pc.printf("gainData middleLevel:%d\n",prf->gainData.middleLevel);
    pc.printf("lightsw:%d\n",prf->lightsw);
    pc.printf("continueusMode:%d\n",prf->continueusMode);
    pc.printf("isSend:%d\n",prf->isSend);
    pc.printf("xbeeAdress:%X\n",prf->xbeeAdress);

}
void dumpPrefReciever(PrefReciever *prf)
{

    pc.printf("xbeeAdress:%X\n",prf->xbeeAdress);

}
void dumpPrefServer(PrefServer *prf)
{
    pc.printf("xbeeAdress:%X\n",prf->xbeeAdress);
    pc.printf("server ip:%d.%d.%d.%d\n",prf->serverAddress[0],prf->serverAddress[1],prf->serverAddress[2],prf->serverAddress[3]);
    pc.printf("subnet ip:%d.%d.%d.%d\n",prf->subnetMask[0],prf->subnetMask[1],prf->subnetMask[2],prf->subnetMask[3]);
    pc.printf("router ip:%d.%d.%d.%d\n",prf->routerAddress[0],prf->routerAddress[1],prf->routerAddress[2],prf->routerAddress[3]);

    pc.printf("Server Port:%d\n",prf->serverPort);
    
    pc.printf("Destination ip:%d.%d.%d.%d\n",prf->destinationAddress[0],prf->destinationAddress[1],prf->destinationAddress[2],prf->destinationAddress[3]);
    pc.printf("Destination Port:%d\n",prf->destinationPort);

}