#include "mbed.h"
#include "types.h"
#include "config.h"
#include "serialRecieve.h"
#include "data_models.h"
#include "layer_frame.h"
#include "leds.h"

extern Serial pc;

Payload payload;
uint8_t *payByte;
uint8_t payByteIndex;


uint16_t oldFrameNumber;

uint8_t rxBuff[256];
uint8_t rxBuffWindex;
uint8_t rxBuffRindex;

Timer timeout;
bool isFirstByte;

extern bool isSendContinueous;
extern PrefSender spref;

uint8_t serialRead(void){
    uint8_t data=rxBuff[rxBuffRindex];
    rxBuffRindex++;
    return data;
}
bool serialCheck(void){
    return (rxBuffWindex!=rxBuffRindex);
}

void serialFlush(void){
    rxBuffWindex=0;
    rxBuffRindex=0;
    LPC_UART0->FCR = (7 << 0);
    payByteIndex=0;
    isFirstByte=true;
}



void rxCallback(void){
     uint8_t data=pc.getc();
//     if(data==0x0A && rxBuff[rxBuffWindex-1]== 0x0D)  rxBuff[rxBuffWindex-1]=data; //LF escape
//     else 
     rxBuff[rxBuffWindex]=data;
     rxBuffWindex++;
     
     if(isFirstByte){
        timeout.reset();
        timeout.start();
       
     }
     else if(timeout.read_ms() > 50){
        serialFlush();        
        timeout.stop();
        timeout.reset();
        pc.printf("--------------timeout!!\r\n");
     }
     
}

void serialSendPayload(Payload *_payload){
    
    ledSerialTx();
    
    uint8_t *data = (uint8_t*)_payload;
    
    pc.printf("\r\n---return Send Payload data \r\n");
    
    for(uint8_t i=0 ; i<data[0] ; i++){
     pc.printf("%d:%02X ",i,data[i]);
     }
     
    pc.printf("\r\n---end\r\n");
}


void serialInit(void){

    pc.baud(115200);
    pc.attach(&rxCallback);
    pc.format(8, Serial::None, 1);
    serialFlush();
    
    payByte = (uint8_t*)&payload;
/*
    payByte[0]=sizeof(Payload);
    payByte[1]=0;
    
    payByte = (uint8_t*)&payload.ftype;
*/ 
    
    timeout.stop();
    timeout.reset();
}



void routing(Payload *_payload)
{
  
    switch(_payload->frame.message.command)
    {
        
        
        case SEND_SINGLE:
        {
            spref.continueusMode=0;
            #ifndef _SERVER_TEST_MODE_
            sendPayload(_payload);
            #else
            serialSendPayload(_payload);
            #endif

            DBGF("*******  single send!  *******\r\n");
            
        }
        break;
        
        case SEND_CONTINUEOUS:
        {
            spref.continueusMode=1;
            #ifndef _SERVER_TEST_MODE_
            sendPayload(_payload);
            #else
            serialSendPayload(_payload);
            #endif
            
            DBGF("*******  continueous send!  *******\r\n");
        }
        break;
        
        case SEND_CONT_STOP:
        {
            spref.continueusMode=0;
            memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
            serialSendPayload(_payload);
            
            DBGF("*******  continueous stop!  *******\r\n");
        }
        break;
        
         case RECIEVE:
        {
            DBGF("******  recieve!  *******\r\n");
        }
        break;
        
        case PING:
        {   
            memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
            _payload->frame.message.command=PING;
            _payload->frame.message.device=LED_SENDER;
            serialSendPayload(_payload);
            DBGF("*******  ping!  **************");
        }
        break;
        
        case SET_TX_GAIN:
        {
            spref.gainData.gain=_payload->frame.message.data[0];
            spref.gainData.middleLevel=_payload->frame.message.data[1];
            memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
            setTxLevel(&spref.gainData);

            serialSendPayload(_payload);
            
            DBGV("*******   set tx gain:%d mid level:%d *******\r\n",spref.gainData.gain,spref.gainData.middleLevel);
        }
        break;
        
        case SET_LIGHT_CONTROL:
        {   
             spref.lightsw = _payload->frame.message.data[0];
             memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
//             _payload->frame.message.device=LED_SENDER;
//             _payload->frame.message.command=SET_LIGHT_CONTROL;
             lightIlluminateChange(spref.lightsw);
            
            serialSendPayload(_payload);
            DBGV("*******  SET_LIGHT_CONTROL! %d **************", spref.lightsw);
        }
        break;
        
    }

}

void readProcess(void){


    if(!serialCheck()) return;
    
    ledSerialRx();
   
     payByte[payByteIndex]=serialRead();
     payByteIndex++;
    
    if(payByteIndex<(sizeof(Payload))) return;
    
    payByteIndex=0;

    ledSerialDataCmp();
    
     networkToPayload(&payload);
/*
    if( payload.frame.message.frameNumber == oldFrameNumber){
    
        DBGF("-------- same frame.. \r\n");
        return;   
     }
*/    
//    dumpPayload(&payload);

    


    routing(&payload);
    
    oldFrameNumber= payload.frame.message.frameNumber;

    
     DBGF("\r\n*******  tx send!  *******\r\n");
}

