#include "mbed.h"
#include "types.h"
#include "config.h"
#include "culc_crc16.h"
#include "layer_frame.h"
#include "data_models.h"
#include "leds.h"
#include "serialRecieve.h"


volatile int symbolCode;
volatile int pulseCounter;
volatile int pulseState;
volatile bool isSend;

volatile bool isSendContinueous;
volatile bool isSendContinued;

Payload sendedPayload;
uint16_t sendedFrameNumber;

volatile uint8_t buff[70];
volatile uint8_t buffIndex;

volatile float txMax;
volatile float txMin;
volatile float txMid;


AnalogOut dac(p18);
DigitalOut lightPowerOn(p8);
DigitalOut out(p19);

DigitalOut lightButtonLed(p29);

extern PrefSender spref;


void lightIlluminateChange(uint8_t _sw){
    
    if(_sw == 0){
        lightPowerOn=0;
        spref.lightsw = 0;
        lightButtonLed = 0; 
    }
    else{
    
        lightPowerOn=1;
        spref.lightsw = 1;
        lightButtonLed = 1; 
             
    }

}

void setTxLevel(TxGainData *_data)
{
    
    uint8_t _gain = _data->gain;
    uint8_t _mid = _data->middleLevel;
    
    if( (_mid  > 10) || (_mid <1) ) return;
    if(_gain > 10) return;
    
    if(_gain == 0){
        txMax = 0;
        txMin = 0;
        txMid = 0;
        return;
    }

    float g = (float)_gain*0.1;
    float mid = (float)_mid*0.1;
    
    txMax = kDAC_GAIN_MAX * g;
    txMin = kDAC_GAIN_MIN * g;
    txMid = mid * g;
}

void timer1_init(void)
{
    LPC_SC->PCLKSEL0 &= ~(3UL << 4);   //clear bits 96MHz
    LPC_SC->PCLKSEL0 |=  (1UL << 4);   //set bit

    LPC_SC->PCONP |=1 << 2;            //timer1 power on
    LPC_TIM1->MR0 = kTImerCount;        //1/96MHz = 0.010416666 us :(  1/(0.010416666 us * 1667) * 2) = 28.794kHz
    LPC_TIM1->MCR = 3;              //interrupt and reset control
                                    //3 = Interrupt & reset timer1 on match
                                    //1 = Interrupt only, no reset of timer1
//    NVIC_EnableIRQ(TIMER1_IRQn);    //enable timer1 interrupt
//    LPC_TIM1->TCR = 1;              //enable Timer1
    enableTimer();
}

void enableTimer(void)
{
    LPC_TIM1->MR0 = kTImerCount;
    NVIC_EnableIRQ(TIMER1_IRQn);
    LPC_TIM1->TCR = 1;              //enable Timer1
}
void disableTimer(void)
{
    NVIC_DisableIRQ(TIMER1_IRQn);
    LPC_TIM1->TCR = 0;              //disable Timer1
}

void preambleGenerator(){

    symbolCode = 4;   
    while( pulseCounter <=96 )  {readProcess();}
    pulseCounter = 0;
}

void sendByteData(uint8_t _data){
//    printf("%02X ",_data);
    pulseCounter = 0;
    
    symbolCode = (_data & 0x03);  
    while( pulseCounter < 24 ) {readProcess();}
    pulseCounter = 0;
   
    symbolCode = ( (_data & 0x0C ) >> 2);
    while( pulseCounter < 24 ) {readProcess();}
    pulseCounter = 0;
    
    symbolCode = ( (_data & 0x30 ) >> 4);
    while( pulseCounter < 24 ) {readProcess();}
    pulseCounter = 0;
    
    symbolCode = ( (_data & 0xC0 ) >> 6);
    while( pulseCounter < 24 ){readProcess();}
    pulseCounter = 0;
    
    

}


void pulseGenerator(){

    if(pulseState == -1)    pulseState = 1;
    else                    pulseState = -1;

    
    if(pulseState<0)    {  out = 1; dac = txMax; }
    else                {  out = 0; dac = txMin; }

}
extern "C" void TIMER1_IRQHandler (void)
{
    if((LPC_TIM1->IR & 0x01) != 0x01)  return; // if MR0 interrupt, proceed
  
    LPC_TIM1->IR |= 1 << 0;         // Clear MR0 interrupt flag

     pulseCounter++;


 switch(symbolCode){
     
    case 0:
    {
        if( pulseCounter <= 6)  pulseGenerator();
        else                    { out = 0; dac=txMid;}
    }
    break;
    
    case 2:
    {
        if( (pulseCounter > 6)&(pulseCounter <= 12) )  pulseGenerator();
        else                                           { out = 0; dac=txMid;}
    }
    break;
    
    case 1:
    {
        if( (pulseCounter > 12)&(pulseCounter <= 18) )  pulseGenerator();
        else                    { out = 0; dac=txMid;}
    }
    break;
    
    case 3:
    {
        if( (pulseCounter > 18)&(pulseCounter <= 24 ))  pulseGenerator();
        else                    { out = 0; dac=txMid;}
    }
    break;
    
    case 4:
    {
   //     if(  pulseCounter <= 18 ) pulseGenerator();
         if(  (pulseCounter > 18) & (pulseCounter <= 36) ) pulseGenerator();
        else                    { out = 0; dac=txMid;}
    }
    break;

 }
 
    
}

void initCarrierWave(){
    dac = kDAC_OFF;
    out=0;

    pulseCounter=0;
    symbolCode = 0;
    pulseState = -1;
    
    spref.gainData.gain = kTxGain;
    spref.gainData.middleLevel = kTxMidLevel;

    setTxLevel( &spref.gainData );
    
    spref.lightsw=1;
    lightIlluminateChange(spref.lightsw);
    
     spref.isSend=0;
    spref.continueusMode=0;
    
 
    sendedFrameNumber=0xffff;
    timer1_init();
   
 //  initPayload(&sendedPayload);
}



void sendPayload(Payload *_payload){

    #ifdef _SERVER_TEST_MODE_
    dumpPayload(_payload);
    #endif
    
    makedata(_payload);
    
    ledLightTx();
    
    for(uint8_t i=0 ; i < kContSendNum ; i++){
     sendbuff();
    }

}

void makedata(Payload *_payload ){

    uint16_t fNum= _payload->frame.message.frameNumber;
    
//    printf("\n------------------- fnum:%0X\n",fNum);
    if( fNum != sendedFrameNumber ){
    
        sendedFrameNumber = fNum;
        
        memcpy(&sendedPayload,_payload,sizeof(Payload));
        sendedPayload.frame.message.sum = culcSum(&sendedPayload);
        
        Payload tmp;
         memcpy(&tmp,&sendedPayload,sizeof(Payload));
        
        Frame *frame=&tmp.frame;
        
        payloadToNetwork(&tmp);
//        dumpPayload(&tmp);
         
        uint16_t crc = 0xffff;   
        uint8_t index=0;
    
        //frame type
        buff[index]=tmp.ftype;
        crc = One_Byte_CRC16_Calc( crc , buff[index]);
    
        index++;
        uint8_t *data=(uint8_t*)&frame->id;
        
        //id
        for(int8_t i=15 ; i>=0 ;i--){
            buff[index]=data[i];
            crc = One_Byte_CRC16_Calc( crc , buff[index]);
            index++;
        }

        //message
        data=(uint8_t*)&frame->message;
        for(int8_t i=47 ; i>=0 ;i--){
            buff[index]=data[i];
            crc = One_Byte_CRC16_Calc( crc , buff[index]);
            index++;
        }
   
        //CRC
        buff[index] =(uint8_t)(crc&0x00ff);
        index++;
        buff[index] =(uint8_t)(crc>>8);
      
        }
        
}


void sendComp(void){
    isSend=false;
}

void sendbuff(void){
    if(isSend) return;
//    ledDevice();
    
    isSend=true;
    preambleGenerator();    
    for(uint16_t i=0 ; i<67 ; i++) sendByteData( buff[i] );
    isSend=false;
}
