#ifndef _DATA_MODELS_
#define _DATA_MODELS_

#include "types.h"

//frame type 
typedef enum{
    Ftype_NoID  =0,
    Ftype_Type_A=1,
    Ftype_Type_B=4
} Ftype;

typedef enum{
    SERVER,
    LED_SENDER,
    LED_RECIEVER
} Device;

typedef enum{
    PING,
    ACK,
    RECIEVE,
    SEND_SINGLE,
    SEND_CONTINUEOUS,
    SEND_CONT_STOP,
    SET_TX_GAIN,
    SET_LIGHT_CONTROL
} Command;
//
//for TCP/IP data structure
//

//message data  48byte(size fix) 
typedef struct{
    uint16_t totalSize;   //2(total size) + 2(frame number) + 1(device) + 1(command) + 40(data:max 40) <--- max 46
    uint16_t frameNumber;
    Device   device;
    Command  command;
    uint8_t  data[40]; //0 fill,size fix
    uint16_t sum;
} Message;

//payload id  16byte 
typedef struct{
//    uint16_t head;              //reserve 0x0000
    uint8_t  personalId[16]; 
} ID;

typedef struct{
    ID      id;         // 16 byte
    Message message;    // 48 byte
} Frame;

//66byte Payload
typedef struct{
    uint16_t    size;     // 2(size) + 1(dummy) + 1(Ftype) + 64(frame) = 68 byte
    uint8_t     dummy;    //adjust Alignment
    Ftype       ftype;  
    Frame       frame;    //64byte
} Payload;




/* ---------------------------------------------------
    message data structure
---------------------------------------------------*/

/*  light&#65533;@illuminate level  */
typedef struct{
    uint8_t gain;           //1~10
    uint8_t middleLevel;    //1~10
} TxGainData;

typedef struct{
    uint16_t currentFrameNumber;
    TxGainData gainData;
    uint8_t lightsw;        //0:light off 1:light on
    uint8_t continueusMode; //0:single 1:continueus
    uint8_t isSend;
    uint8_t dummy;
    uint32_t xbeeAdress;   
} PrefSender;

typedef struct{
    uint32_t xbeeAdress;
} PrefReciever;

typedef struct{
    uint32_t xbeeAdress;
    
    uint8_t serverAddress[4];
    uint8_t subnetMask[4];
    uint8_t routerAddress[4];
    uint16_t serverPort;
    
    uint8_t destinationAddress[4];
    uint16_t destinationPort;   
} PrefServer;



void initPayload(Payload *_payload);

void payloadToNetwork(Payload *_payload);
void networkToPayload(Payload *_payload);

void initTestPayloadData(Payload *_payload);
uint16_t culcSum(Payload *_payload);

void dumpPayload(Payload *_payload);
void dumpPrefSender(PrefSender *prf);
void dumpPrefReciever(PrefReciever *prf);
void dumpPrefServer(PrefServer *prf);

#endif