#include "mbed.h"

Serial pc(USBTX, USBRX);

#include "config.h"
#include "layer_frame.h"
#include "leds.h"
#include "serialRecieve.h"

DigitalIn din(p20);
DigitalIn lightButton(p30);


extern Payload sendedPayload;

volatile uint16_t count;
volatile PrefSender spref;

volatile int oldBt;
volatile bool isChatterWait;
Timeout chatterWait;

void ctProcess(void)
{
    if(oldBt ^ lightButton)
    {
        spref.lightsw = lightButton;
        oldBt = spref.lightsw;
        lightIlluminateChange(lightButton);
    }
    
    isChatterWait = false;
}



int main(){
    
    serialInit();
    
    #ifdef _SERVER_TEST_MODE_
    pc.printf("*.*.*.*.*.*.*.   T E S T  M O D E *.*.*.*.*.*.*.*.*.*.\n");  
    #endif
    
    pc.printf("sender start\n");
    din.mode(PullUp);
    
    lightIlluminateChange(0); 
    
    spref.currentFrameNumber = 0;
    spref.gainData.gain = kTxGain;
    spref.gainData.middleLevel = kTxMidLevel;
    
    spref.continueusMode = 0;
    spref.isSend = 0;
    spref.xbeeAdress = 0;
    
    Payload test;
    initTestPayloadData(&test);
    
    initCarrierWave(); 
    
    startLed();
    
    isChatterWait = false;
    spref.lightsw = lightButton;
    oldBt = spref.lightsw;
    
    lightIlluminateChange(spref.lightsw); 

    while(1){
    
        //light button push or release
        if( (oldBt ^ lightButton) && !isChatterWait ){
        
        isChatterWait = true;
        chatterWait.attach(&ctProcess,0.05);
         
        
        }
               
        readProcess();

        
        if(spref.continueusMode == 1) sendPayload(&sendedPayload);

        else if(!din) sendPayload(&test);

        else sendByteData(0x00);
        
               
    }
    
}

