#include "net_routing.h"
#include "types.h"
#include "config.h"
#include "xbee_lib.h"
#include "tcp_client.h"


extern PrefServer pref;
extern PrefSender spref;
extern PrefReciever rpref;

extern Serial pc;

void netRouting(Payload *_payload)
{
       
//    dumpPayload(_payload);

    
    switch(_payload->frame.message.device)
    {
        case LED_SENDER:
        {
            #ifndef _SERVER_TEST_MODE_

            xbeeSend(kLedSender,_payload);
            #else
                
                switch(_payload->frame.message.command)
                {
                    case PING:
                    {
                        dumpPrefSender(&spref);
                         memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
                         _payload->frame.message.device=LED_SENDER;
                         DBGF("******* [TEST MODE] sender ping!  **************\r\n");
                    }
                    break;
                    case SEND_SINGLE:
                    {
                        spref.continueusMode=0;
                        spref.currentFrameNumber=_payload->frame.message.frameNumber;
                        dumpPrefSender(&spref);
                        
                         memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
                         _payload->frame.message.device=LED_SENDER;
                         DBGF("*******  [TEST MODE] sender single send!  **************\r\n");
                        
                    }
                    break;
                    case SEND_CONTINUEOUS:
                    {
                        spref.continueusMode=1;
                        spref.currentFrameNumber=_payload->frame.message.frameNumber;
                        dumpPrefSender(&spref);
                        
                         memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
                         _payload->frame.message.device=LED_SENDER;
                         DBGF("*******  [TEST MODE] sender continues send!  **************\r\n");
                        
                    }
                    break;
                    case SEND_CONT_STOP:
                    {
                        spref.continueusMode=0;
                        spref.currentFrameNumber=_payload->frame.message.frameNumber;
                        dumpPrefSender(&spref);
                        
                         memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
                         _payload->frame.message.device=LED_SENDER;
                         DBGF("*******  [TEST MODE] sender continues stop!  **************\r\n");
                        
                    }
                    break;
                    
                    case SET_TX_GAIN:
                    {   
                        spref.gainData.gain=_payload->frame.message.data[0];
                        spref.gainData.middleLevel=_payload->frame.message.data[1];
                        
                        dumpPrefSender(&spref);
                        
                         memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
                         _payload->frame.message.device=LED_SENDER;
                         DBGF("*******  [TEST MODE] sender tx lebel set!  **************\r\n");
                    }
                    break;
                    case SET_LIGHT_CONTROL:
                    {
                        spref.lightsw=_payload->frame.message.data[0];
                        
                        dumpPrefSender(&spref);
                        
                         memcpy(_payload->frame.message.data,&spref,sizeof(PrefSender));
                         _payload->frame.message.device=LED_SENDER;
                         DBGF("*******  [TEST MODE] sender light on set!  **************\r\n");
                        
                    }
                    break;
                }
                dumpPayload(_payload);
                udpSendPayload(_payload);
            #endif
            break;
        }
        
        case LED_RECIEVER:
        {
            #ifndef _SERVER_TEST_MODE_

            xbeeSend(kLedReciever,_payload);
            #else
                if(_payload->frame.message.command==PING){
                dumpPrefReciever(&rpref);
                memcpy(_payload->frame.message.data,&rpref,sizeof(PrefReciever));
                _payload->frame.message.device=LED_RECIEVER;
                dumpPayload(_payload);
                udpSendPayload(_payload);
                DBGF("*******  [TEST MODE] reciever ping!  **************\r\n");
                
            }
            
            #endif
            break;
        }
        case SERVER:
        {
            if(_payload->frame.message.command==PING){
                #ifdef _SERVER_TEST_MODE_
                    dumpPrefServer(&pref); 
                #endif
                memcpy(_payload->frame.message.data,&pref,sizeof(PrefServer));
                _payload->frame.message.device=SERVER;
                udpSendPayload(_payload);
                DBGF("*******  server ping!  **************\r\n");
            }
            break;
        }
    
    }

    
}