#include "xbee_rec_route.h"
#include "config.h"
#include "XBee.h"

#include "types.h"

#include "xbee_lib.h"
#include "tcp_client.h"
#include "leds.h"

extern Serial pc;

extern XBee xbee;
extern ZBRxResponse zbRx;


void xbeeRecieveRouting(void)
{
#ifdef _SERVER_TEST_MODE_
return;
#else
     xbeeReadPacket();
    
   
        if (isXbeeAvaiable()) {
            
            
    
            DBGF("xbee aviable!\r\n");
        
            if (xbee.getResponse().getApiId() == ZB_RX_RESPONSE) {
                
                ledXBeeRx();
                
                xbee.getResponse().getZBRxResponse(zbRx);
                
                Payload payload;

                uint16_t length = (unsigned char)zbRx.getData()[0];
                length =(length<<8) + (unsigned char)zbRx.getData()[1];
                
                DBGV("length=%04X\r\n",length);
                
                memcpy(&payload, (unsigned char *)zbRx.getData(), length);

                
                
                networkToPayload(&payload);
               
                routing(&payload);
                /*
                pc.printf("xbee recieve!! size:%d\r\n",length);
                
                pc.printf("---------dump end\r\n");
                */
                
                
           
            }
        //    pc.printf("\r\n");
        }
    
#endif    
}

void routing(Payload *_payload)
{
//     dumpPayload(_payload);
    switch(_payload->frame.message.command)
    {
        case SEND_SINGLE:
        {
        //    _payload->frame.message.command=ACK;
        //    xbeeSend(0x4086B0D5,_payload);
            DBGF("*******[XBeeRec]  send!  *******\r\n");
        }
        break;
        
        case RECIEVE:
        {
            udpSendPayload(_payload);
            DBGF("******[XBeeRec]  recieve!  *******\r\n");
        }
        break;
        
        case PING:
        {   
            
            udpSendPayload(_payload);
            DBGF("*******[XBeeRec]  ping!  **************\r\n");
        }
        break;
        
        case ACK:
        {   
            udpSendPayload(_payload);
            DBGF("*******[XBeeRec]  ACK!  **************\r\n");
        }
        
        case SET_TX_GAIN:
        {
            udpSendPayload(_payload);
            DBGF("*******[XBeeRec]  SET_TX_GAIN!  **************\r\n");
        }
        break;
        case SET_LIGHT_CONTROL:
        {
            udpSendPayload(_payload);
            DBGF("*******[XBeeRec]  SET_LIGHT_CONTROL!  **************\r\n");
        }
        break;
    }

}
