#include "types.h"
#include "mbed.h"
#include "config.h"
#include "tcp_error.h"
#include "tcp_client.h"
#include "tcp_server.h"

#include "leds.h"
extern Serial pc;

 Host iPadserver;

extern UDPSocket sock;

extern IpAddr inCommingIp;
extern PrefServer pref;

extern bool healthiPad;
bool isSend;


ConnectStatus iPadServerStatus;

Timer checkTimer;
Ticker clientCheck;

void clientInit(void){
 
    iPadServerStatus=close;
    
    pref.destinationPort = kClientPort;
    
    uint8_t tmpip[4]={kClientIp};   
    memcpy((void*)pref.destinationAddress,tmpip,4);
      
    pc.printf("client IP Address is [%d.%d.%d.%d] Port:%d\r\n", pref.destinationAddress[0], pref.destinationAddress[1], pref.destinationAddress[2], pref.destinationAddress[3],pref.destinationPort) ;
    healthiPad=true;
    isSend=false;
    
    iPadserver = Host(IpAddr(kClientIp), kClientPort);
}


int udpSend(char *data,int length){

    if(isSend) return -1;
    
    isSend = true;
    
    ledTcpTx();
     
    int ret=sock.sendto(data, length, &iPadserver);
    
    isSend=false;
    
    return ret;
    
}

void checkConnect(void){
#ifdef DEBUG
static uint16_t checkSendCount=0;
#endif    
    char d = kHealthCheckmbed;
    
    udpSend( &d , 1 );
    healthiPad=true;
    DBGV("send mbed checker to iPad health check %d\n",checkSendCount++);

}



void connectCheckStart(void)
{

    clientCheck.attach(&checkConnect,kiPadServerCheckInterval);   
}



int udpSendPayload(Payload *_payload)
{
    uint8_t tmp[_payload->size];
    
    memcpy(tmp,(uint8_t*)_payload,_payload->size);
    
    payloadToNetwork((Payload *)tmp);
    
    return udpSend((char*)tmp,_payload->size);
}


