#include "mbed.h"
#include "types.h"
#include "config.h"
#include "XBee.h"
#include "xbee_lib.h"

#include "leds.h"
extern Serial pc;

XBee xbee(p13, p14);
ZBRxResponse zbRx = ZBRxResponse();

extern PrefServer pref;
extern PrefSender spref;
extern PrefReciever rpref;

void xbeeInit(void)
{

    pref.xbeeAdress = kMyXBeeAddress;
    spref.xbeeAdress = kLedSender;
    rpref.xbeeAdress = kLedReciever;

#ifdef _SERVER_TEST_MODE_
return;
#else

    LPC_UART1->MCR |= (1<<7); // CTSEN
    LPC_PINCON->PINSEL1 &= ~(3 << 2);
    LPC_PINCON->PINSEL1 |= (1 << 2); // UART CTS
    xbee.begin(kXBeeBoudRate);
    

    
    pc.printf("XBee setup OK!  XBee serial boudrate:%d address:%04X\r\n",kXBeeBoudRate,pref.xbeeAdress);
#endif
}

void xbeeSend(uint32_t addr , Payload *_payload)
{
#ifdef _SERVER_TEST_MODE_
return;
#else
    ledXBeeTx();
    
    XBeeAddress64 deviceAdr = XBeeAddress64(0x0013a200, addr);
    
    uint16_t length = sizeof(Payload);
    _payload->size = length;
    uint8_t tmp[length];
    
    memcpy(tmp , (uint8_t*)_payload , length);
    
    payloadToNetwork((Payload*)tmp);
    ZBTxRequest zbTx = ZBTxRequest(deviceAdr , tmp , length );
    
    xbee.send(zbTx);
    DBGF("+++++ xbee send!!\r\n");  
#endif 
}

void xbeeReadPacket(void)
{
#ifndef _SERVER_TEST_MODE_
    xbee.readPacket();
#endif
    
}
bool isXbeeAvaiable(void)
{
#ifdef _SERVER_TEST_MODE_
return false;
#else
   return xbee.getResponse().isAvailable();
#endif
}