#include "types.h"
#include "mbed.h"
#include "config.h"
#include "tcp_server.h"
#include "tcp_client.h"

#include "data_models.h"
#include "xbee_lib.h"
#include "net_routing.h"

#include "leds.h"

extern Serial pc;

Host client;
IpAddr inCommingIp;


extern PrefServer pref;
extern PrefSender spref;
extern PrefReciever rpref;

extern bool isHostConnected;


UDPSocket sock;

bool healthiPad;

int serverInit(void)
{
 
    sock.setOnEvent(&onUDPSocketEvent);
    
    Host x(IpAddr(kSserverIp),kServerPort);
    
    pc.printf("seting bind\n");
    UDPSocketErr udpErr = sock.bind( x );
    
    if ( udpErr != UDPSOCKET_OK ){
     pc.printf("error %d\n", udpErr);
     return -1;
     }
    pc.printf("server setting OK\n");
    
    spref.currentFrameNumber = 0;
    spref.gainData.gain=10;
    spref.gainData.middleLevel=5;
    spref.lightsw=1;
    spref.continueusMode=0;
    spref.isSend=0;

    return 0;
}


void onUDPSocketEvent(UDPSocketEvent e) {
#ifdef DEBUG
  static  uint16_t checkMbedSendCount=0;
  static  uint16_t checkiPadRecCount=0;
#endif
    char buff[256];
   

    if (e == UDPSOCKET_READABLE) 
    {
        ledTcpRx();
        
        Host client;
    
        int size = sock.recvfrom(buff, sizeof(buff), &client);

        DBGV("recieve from %d.%d.%d.%d\r\n", (unsigned char)client.getIp()[0], (unsigned char)client.getIp()[1], (unsigned char)client.getIp()[2], (unsigned char)client.getIp()[3]);
      
        
        char d;
        if( size == 1)
        {
            switch(buff[0])
            {
                case kHealthCheckiPad:
                {
                     d=kHealthCheckiPad;
                     udpSend(&d, 1);
                     DBGV("return send mbed checker to iPad %d\n",checkiPadRecCount++);
                }
                break;
                
                case kHealthCheckmbed:
                {
                     healthiPad=false;
                      DBGV("recieve mbed checker %d\n",checkMbedSendCount++);
                }
                break;
            }
            
            return;
        }
        
   
        Payload pl;
        memcpy( &pl , buff , sizeof(Payload) );
        
//        dumpPayload(&pl); 
                
        networkToPayload(&pl);
                 
        netRouting(&pl);
     }
}


void recieveDump(char *data , int length){
     pc.printf("size = %d\n -- -id\n",length);
     
     for(int i=0;i<16;i++) pc.printf("%d:%0x ",i,data[i]);
     pc.printf("\n--- data\n");
     
     int count=0;
     for(int i=0;i<(length-16);i++){
      pc.printf("%02d:%02x ",i,data[16+i]);
      if( count==15 ) {count=0; pc.printf("\n");}
      else count++;
     }
     
     pc.printf("\n---frame end\n");
}

