#include "mbed.h"
#include "leds.h"
#include "config.h"

#define kLedOnTime 0.05

#define kTcpConnect p30
#define kTcpRx p29
#define kTcpTx p28

#define kXBeeRx  p27
#define kXBeeTx  p26

Timeout led_tcp_rx;
Timeout led_tcp_tx;
Timeout led_xbee_snd;
Timeout led_xbee_rec;

#ifndef _SERVER_TEST_MODE_
DigitalOut ledTcpCon(kTcpConnect);
DigitalOut ledTcpRec(kTcpRx);
DigitalOut ledTcpSend(kTcpTx);

DigitalOut ledXBeeRec(kXBeeRx);
DigitalOut ledXBeeSend(kXBeeTx);
#else
DigitalOut ledTcpCon(LED1);
DigitalOut ledTcpRec(LED2);
DigitalOut ledTcpSend(LED3);
#endif


void offTcpRx(void){
    ledTcpRec=0;
}
void offTcpTx(void){
    ledTcpSend=0;
}
void offXBeeRx(void){
#ifndef _SERVER_TEST_MODE_
    ledXBeeRec=0;
#endif
}
void offXBeeTx(void){
#ifndef _SERVER_TEST_MODE_
    ledXBeeSend=0;
#endif
}

void ledTcpRx(void)
{
    if(ledTcpRec == 1) return;
    ledTcpRec=1;
    led_tcp_rx.attach(&offTcpRx,kLedOnTime);
}
void ledTcpTx(void)
{
    if(ledTcpSend == 1) return;
    ledTcpSend=1;
    led_tcp_tx.attach(&offTcpTx,kLedOnTime);
}
void ledXBeeRx(void)
{
#ifndef _SERVER_TEST_MODE_
    if(ledXBeeRec == 1) return;
    ledXBeeRec=1;
    led_xbee_rec.attach(&offXBeeRx,kLedOnTime);
#endif
}
void ledXBeeTx(void)
{
#ifndef _SERVER_TEST_MODE_
    if(ledXBeeSend == 1) return;
    ledXBeeSend=1;
    led_xbee_snd.attach(&offXBeeTx,kLedOnTime);
#endif
}


void ledTcpConnect(bool isConnect)
{
    if(isConnect)   ledTcpCon=1;
    else            ledTcpCon=0;
}


void startLed(void){
    ledTcpCon=1;
    wait(0.2);
    ledTcpCon=0;
    
    ledTcpRec=1;
    wait(0.2);
    ledTcpRec=0;
        
    ledTcpSend=1;
    wait(0.2);
    ledTcpSend=0;
#ifndef _SERVER_TEST_MODE_    
    ledXBeeRec=1;
    wait(0.2);
    ledXBeeRec=0;
    
    ledXBeeSend=1;
    wait(0.2);
    ledXBeeSend=0;
#endif
    
    wait(0.4);
    
    for(uint8_t i=0; i<2 ;i++){
    
        ledTcpCon=1;
        ledTcpRec=1;
        ledTcpSend=1;
#ifndef _SERVER_TEST_MODE_
        ledXBeeRec=1;
        ledXBeeSend=1;
#endif
        wait(0.05);
        
        ledTcpCon=0;
        ledTcpRec=0;
        ledTcpSend=0;
#ifndef _SERVER_TEST_MODE_
        ledXBeeRec=0;
        ledXBeeSend=0;
#endif
        wait(0.1);
        
    }

}