#include "mbed.h"

Serial pc(USBTX, USBRX);

#include "xbee_lib.h"
#include "EthernetNetIf.h"
#include "config.h"
#include "tcp_server.h"
#include "tcp_client.h"
#include "xbee_rec_route.h"

#include "leds.h"

#include "data_models.h"

volatile PrefServer pref;
volatile PrefSender spref;
volatile PrefReciever rpref;

EthernetNetIf eth ;   

Ticker connectCheck;

DigitalIn  recSw(p20);
Timeout chatter;
bool isPressed;

extern bool healthiPad;


class Watchdog {  
public:
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4 
        LPC_WDT->WDTC = s * (float)clk;         
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset        
        kick();
    }
    
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

Watchdog w;






void testModeInit(void)
{
    recSw.mode(PullUp);
}

void testSendRecieveData()
{

   Payload payload;
   initTestPayloadData(&payload);

   udpSendPayload(&payload); 
   
}






int main() {

    
    
    pc.baud(115200);

   
    uint8_t tmpip[4]={kSserverIp};
    uint8_t tmpsubnet[4]={kSubnetMask};
    uint8_t tmprt[4]={kRouterIp};
        
    EthernetNetIf eth( //  -- static IP address
        IpAddr(kSserverIp),     // IP Address
        IpAddr(kSubnetMask),   // Subnet Mask
        IpAddr(kRouterIp),     // Default Gateway
        IpAddr(kRouterIp)      // DNS Server
    ) ;
    
    #ifdef _SERVER_TEST_MODE_
    pc.printf("*.*.*.*.*.*.*.   T E S T  M O D E *.*.*.*.*.*.*.*.*.*.\n");
    testModeInit(); 
    #endif
    

    if( eth.setup() != ETH_OK )
    {
        pc.printf("Ether Setup Error\r\n");
        return -1;
    }
    pc.printf("Ether Setup OK\r\n");

    memcpy((void*)pref.serverAddress,tmpip,4);
    pc.printf("mbed IP Address is [%d.%d.%d.%d]\r\n", pref.serverAddress[0], pref.serverAddress[1], pref.serverAddress[2], pref.serverAddress[3]) ;
    
    memcpy((void*)pref.subnetMask,tmpsubnet,4);
    pc.printf("mbed subnet Address is [%d.%d.%d.%d]\r\n", pref.subnetMask[0], pref.subnetMask[1], pref.subnetMask[2], pref.subnetMask[3]) ;
    
    memcpy((void*)pref.routerAddress,tmprt,4);
    pc.printf("mbed router Address is [%d.%d.%d.%d]\r\n", pref.routerAddress[0], pref.routerAddress[1], pref.routerAddress[2], pref.routerAddress[3]) ;

    ;
    
    xbeeInit();

    serverInit();
    clientInit();
    
    startLed();
    
    connectCheckStart();
 
//    w.kick(2.5); //watch dog timer set

    while(1) {
    
        w.kick();
        
        Net::poll();
       
        
        #ifdef _SERVER_TEST_MODE_
        if(!recSw){
            testSendRecieveData();
            wait(0.5);
        }
       #else
        xbeeRecieveRouting();
         #endif
        if(healthiPad)  ledTcpConnect(false);
        else            ledTcpConnect(true);

    }
}
