#include "xbee_rec_route.h"
#include "config.h"
#include "XBee.h"

#include "types.h"

#include "xbee_lib.h"
#include "tcp_client.h"
#include "leds.h"

extern XBee xbee;
extern ZBRxResponse zbRx;


void xbeeRecieveRouting(void)
{

     xbeeReadPacket();
    
   
        if (isXbeeAvaiable()) {
            
            
    
            DBGF("xbee aviable!\r\n");
        
            if (xbee.getResponse().getApiId() == ZB_RX_RESPONSE) {
                
                ledXBee();
                
                xbee.getResponse().getZBRxResponse(zbRx);
                
                Payload payload;

                uint16_t length = (unsigned char)zbRx.getData()[0];
                length =(length<<8) + (unsigned char)zbRx.getData()[1];
                
                DBGV("length=%04X\r\n",length);
                
                memcpy(&payload, (unsigned char *)zbRx.getData(), length);

                networkToPayload(&payload);
               
                routing(&payload);
                /*
                printf("xbee recieve!! size:%d\r\n",length);
                
                printf("---------dump end\r\n");
                */
                
                
           
            }
        //    printf("\r\n");
        }
    
    
}

void routing(Payload *_payload)
{
//     dumpPayload(_payload);
    switch(_payload->message.command)
    {
        case SEND:
        {
            _payload->message.command=ACK;
        //    xbeeSend(0x4086B0D5,_payload);
            DBGF("*******  send!  *******\r\n");
        }
        break;
        
         case RECIEVE:
        {
            DBGF("******  recieve!  *******\r\n");
        }
        break;
        
         case PING:
        {   
            _payload->message.command=ACK;
       //     xbeeSend(0x4086B0D5,_payload);
            tcpSendPayload(_payload);
            DBGF("*******  ping!  **************\r\n");
        }
        break;
        
         case ACK:
        {   
            tcpSendPayload(_payload);
            DBGF("*******  ACK!  **************\r\n");
        }
        break;
    }

}
