#include "types.h"
#include "mbed.h"
#include "config.h"
#include "tcp_error.h"
#include "tcp_client.h"

#include "leds.h"

extern IpAddr inCommingIp;


Host server;
TCPSocket sendSock;
ConnectStatus clientStatus;
Timer checkTimer;
Ticker clientCheck;

IpAddr clientIp;
int clientPort;

void onSendEvent (TCPSocketEvent e) {
    DBGF("... client event arrival!\r\n");
    switch(e)
    {
        case TCPSOCKET_CONNECTED:
        {
            ledTcpConnect(true);
            
            char str[]="wellcome! server connected!";
            
            sendSock.send(str,strlen(str) );
            
            clientStatus=connected;
            DBGF("TCPSOCKET_CONNECTED!!\r\n");
            break;
         }

        case TCPSOCKET_WRITEABLE:
        {
            DBGF("TCPSOCKET_WRITEABLE!!\r\n");
            clientStatus=connected;
            ledTcpConnect(true);
            break;
        }

        case TCPSOCKET_READABLE:
        {   DBGF("TCPSOCKET_READABLE!!\r\n");
            clientStatus=connected;
            ledTcpConnect(true);
            break;
        }
        case TCPSOCKET_CONTIMEOUT:
        {
            DBGF("TCPSOCKET_CONTIMEOUT!!\r\n");
            socketClose();
            ledTcpConnect(false);
            break;
        }
        case TCPSOCKET_CONRST:
        {
             DBGF("TCPSOCKET_CONRST!!\r\n");
             socketClose();
             ledTcpConnect(false);
            break;
        }
        case TCPSOCKET_CONABRT:
        {
             DBGF("TCPSOCKET_CONABRT!!\r\n");
             socketClose();
             ledTcpConnect(false);
            break;
        }
        case TCPSOCKET_ERROR:
        {   DBGF("TCPSOCKET_ERROR\r\n");
            socketClose();
            ledTcpConnect(false);
            break;
            
        }
         case TCPSOCKET_DISCONNECTED:
        {
            DBGF("TCPSOCKET_DISCONNECTED...\r\n");
            socketClose();
            ledTcpConnect(false);
            break;
        }
    }
    DBGF("...client event out\r\n");
}

void clientInit(void){
    sendSock.setOnEvent(&onSendEvent);
    clientStatus=close;
}

int clientConnect(IpAddr ip , int port)
{
    if(clientStatus == connecting){
        DBGF("socket already connecting..\r\n");
        return 0;
    }
    else if(clientStatus == connected){
        DBGF("socket already connected..\r\n");
        return 0;
    }

    Host server(ip, port);
    
    TCPSocketErr err= sendSock.connect(server);
    if (err != TCPSOCKET_OK) {
        DBGF("connect Error. ");
        dispTcpError(err);
        clientStatus=close;
        return -1;
    }
    clientStatus=connecting;    
    return 0;
}

int tcpSend(char *data,int length){

    ledEther();
    int ret = sendSock.send(data, length);

    return ret;
    
}

void checkConnect(void){

    if(clientStatus != close) return;
    
    clientConnect( clientIp,clientPort );
    return;
}

void socketClose(void){
    sendSock.close();
    clientStatus=close;
}



void connectCheckStart(IpAddr ip , int port)
{
    clientIp=ip;
    clientPort=port;
    clientCheck.attach(&checkConnect,3);   
}

int tcpSendPayload(Payload *_payload)
{
    uint8_t tmp[_payload->size];
    
    memcpy(tmp,(uint8_t*)_payload,_payload->size);
    
    payloadToNetwork((Payload *)tmp);
    
    return tcpSend((char*)tmp,_payload->size);
}

