#ifndef _DATA_MODELS_
#define _DATA_MODELS_

#include "types.h"

typedef enum{
    SERVER,
    LED_SENDER,
    LED_RECIEVER
} Device;

typedef enum{
    SEND,
    RECIEVE,
    PING,
    ACK
} Command;

//
//for TCP/IP data structure
//

//48byte message data
typedef struct{
    uint16_t totalSize;   //uint16_t + uint16_t + uint8_t + uint8_t + 42byte
    uint16_t frameNumber;
    Device   device;
    Command  command;
    uint8_t  data[42];
} Message;

//16byte payload id
typedef struct{
    uint16_t head;          //reserve 0x0000
    uint8_t  personalId[14]; 
} PayloadID;

//66byte payload
typedef struct{
    uint16_t  size;     //  2(size) + 64(payload id + message) = 66 byte   
    PayloadID id;       // 16 byte
    Message   message;  // 48 byte
} Payload;


void initPayload(Payload *_payload);

void payloadToNetwork(Payload *_payload);
void networkToPayload(Payload *_payload);

void dumpPayload(Payload *_payload);

#endif