#include "mbed.h"
#include "types.h"
#include "config.h"
#include "XBee.h"
#include "xbee_lib.h"

#include "leds.h"

XBee xbee(p13, p14);
ZBRxResponse zbRx = ZBRxResponse();

void xbeeInit(void)
{
    xbee.begin(9800);
}

void xbeeSend(uint32_t addr , Payload *_payload)
{
    ledXBee();
    
    XBeeAddress64 deviceAdr = XBeeAddress64(0x0013a200, addr);
    
    uint16_t length = sizeof(Payload);
    _payload->size = length;
    uint8_t tmp[length];
    
    memcpy(tmp , (uint8_t*)_payload , length);
    
    payloadToNetwork((Payload*)tmp);
    ZBTxRequest zbTx = ZBTxRequest(deviceAdr , tmp , length );
    
    xbee.send(zbTx);
    DBGF("+++++ xbee send!!\r\n");
    
 
}

void xbeeReadPacket(void)
{
    xbee.readPacket();
}
bool isXbeeAvaiable(void)
{
   return xbee.getResponse().isAvailable();
}