#include "types.h"
#include "mbed.h"
#include "config.h"
#include "tcp_server.h"
#include "tcp_client.h"

#include "data_models.h"
#include "xbee_lib.h"
#include "net_routing.h"

#include "leds.h"

TCPSocket listenSock;
TCPSocket* recieveSock;
Host client;
IpAddr inCommingIp;



extern bool isHostConnected;
int serverInit(void)
{
    listenSock.setOnEvent(&onServerListnerEvent) ;
    
    DBGF("Bindding...\r\n") ;

    if ( listenSock.bind(Host(IpAddr(), kServerPort)) != ETH_OK ){
        DBGF("Bindding Error.\r\n") ;
        return -1 ;
    }
    
    printf("Listen...\r\n");
    
    if ( listenSock.listen() != ETH_OK ){
        DBGF("Listen Error.\r\n") ;
        return -1 ;
    }
    return 0;
}

//Listner Event
void onServerListnerEvent(TCPSocketEvent e)
{
    DBGF("server ---IN TCPSocketEvent ---\r\n");
    
    if ( e == TCPSOCKET_ACCEPT ){
        DBGF("Listening: TCP Socket Accepted\r\n");
        
        if ( listenSock.accept(&client, &recieveSock) != TCPSOCKET_OK ) {
            DBGF("onTcpSocketEvent Error \r\n");
            return; 
        }

        recieveSock->setOnEvent(&onServerRecievetEvent);
        
        //Get Client Side IP Address
        inCommingIp = client.getIp();
        DBGV("Controler IP Address is [%d.%d.%d.%d].\r\n", inCommingIp[0], inCommingIp[1], inCommingIp[2], inCommingIp[3]);
    }

    DBGF("server --- OUT TCPSocketEvent ---\r\n\r\n") ;
 }

void onServerRecievetEvent(TCPSocketEvent e)
{
    DBGF("server --- IN ConnectEvent ---\r\n");
    
    
    switch(e)
    {
        case TCPSOCKET_CONNECTED:
            DBGF("Connected to host.\r\n") ;
            break;
            
        case TCPSOCKET_WRITEABLE:
            DBGF("Can write data to buf.\r\n");
            break;
            
        case TCPSOCKET_READABLE:
            DBGF("Data in buf.\r\n");  
                      
            ledEther();
            
            Payload pl;
            initPayload(&pl);
            
            while ( int len = recieveSock->recv((char*)&pl,256) ) {
                
                //raw data dump
               // dumpPayload(&payload); 
                
                networkToPayload(&pl);
                 
                netRouting(&pl);
                
            }
            ;
            break;
            
        case TCPSOCKET_CONTIMEOUT:
            DBGF("Connection timed out.\r\n");
            break ;
            
        case TCPSOCKET_CONRST:
            DBGF("Connection was reset by remote host.\r\n");
            break ;
            
        case TCPSOCKET_CONABRT:
            DBGF("Connection was aborted.\r\n") ; 
            break ;
            
        case TCPSOCKET_ERROR:
            DBGF("Unknown error.\r\n") ;
            break ;
            
         case TCPSOCKET_DISCONNECTED:
            DBGF("Tcp Socket Disconnected\r\n") ;
            recieveSock->close() ;
            break;   
    }
    DBGF("--- OUT ConnectEvent ---\r\n\r\n");
}

void recieveDump(char *data , int length){
     DBGV("size = %d\n -- -id\n",length);
     
     for(int i=0;i<16;i++) printf("%d:%0x ",i,data[i]);
     DBGF("\n--- data\n");
     
     int count=0;
     for(int i=0;i<(length-16);i++){
      DBGV("%02d:%02x ",i,data[16+i]);
      if( count==15 ) {count=0; printf("\n");}
      else count++;
     }
     
     DBGF("\n---frame end\n");
}

