#include "mbed.h"
#include "xbee_lib.h"
#include "EthernetNetIf.h"
#include "config.h"
#include "tcp_server.h"
#include "tcp_client.h"
#include "xbee_rec_route.h"

#include "leds.h"

EthernetNetIf eth ;   

Ticker connectCheck;

#ifdef _SERVER_TEST_MODE_

#include "data_models.h"

DigitalIn  recSw(p20);
Timeout chatter;
bool isPressed;

void testModeInit(void)
{
    recSw.mode(PullUp);
}

void testSendRecieveData()
{
   Payload payload;
   initPayload(&payload);
   payload.size=sizeof(Payload);
   
   payload.id.head=0x0000;
   uint8_t tmpid[14]={0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x40,0x41,0x42,0x43,0x44};
   for(int i=0;i<sizeof(tmpid);i++) payload.id.personalId[i]=tmpid[i];
   
   
   payload.message.frameNumber=1;
   payload.message.device=LED_RECIEVER;
   payload.message.command=RECIEVE;
   
   uint8_t tmpdata[42]={
    1,2,3,4,5,6,7,8,9,10,
    11,12,13,14,15,16,17,18,19,20,
    21,22,23,24,25,26,27,28,29,30,
    31,32,33,34,35,36,37,38,39,40,
    41,42};
   for(int i=0;i<sizeof(tmpdata);i++) payload.message.data[i]=tmpdata[i];
   
   payload.message.totalSize=
     sizeof(payload.message.totalSize)
    +sizeof(payload.message.frameNumber)
    +sizeof(payload.message.device)
    +sizeof(payload.message.command)
    +sizeof(payload.message.data);

   tcpSendPayload(&payload); 
   
}


#endif



int main() {

    #ifdef _SERVER_TEST_MODE_
    testModeInit();
    #endif
    
    xbeeInit();

    EthernetNetIf eth( //  -- static IP address
        IpAddr(kSserverIp),     // IP Address
        IpAddr(kSubnetMask),   // Subnet Mask
        IpAddr(kRouterIp),     // Default Gateway
        IpAddr(kRouterIp)      // DNS Server
    ) ;

    if( eth.setup() != ETH_OK )
    {
        DBGF("Ether Setup Error\r\n");
        return -1;
    }
    DBGF("Setup OK\r\n");

    IpAddr ip = eth.getIp() ;
    DBGV("mbed IP Address is [%d.%d.%d.%d]\r\n", ip[0], ip[1], ip[2], ip[3]) ;

    serverInit();
    clientInit();
    
    connectCheckStart( IpAddr(kClientIp),kClientPort );
    wait(2);
    ledEther();
    ledXBee();
    ledDevice();

    while(1) {
        Net::poll();
        
        #ifdef _SERVER_TEST_MODE_
        if(!recSw){
            testSendRecieveData();
            wait(2);
        }
        #else
        xbeeRecieveRouting();
        #endif

    }
}
