#include "types.h"
#include "data_models.h"
#include "EthernetNetIf.h"


void initPayload(Payload *_payload)
{
    _payload->size=sizeof(Payload);
    for(int i=0 ; i < sizeof(_payload->id.personalId) ; i++) _payload->id.personalId[i]=0;
    
    _payload->message.frameNumber=0;
    _payload->message.device=SERVER;
    _payload->message.command=SEND;
    
    for(int i=0 ; i < sizeof(_payload->message.data) ; i++) _payload->message.data[i]=0;
}

void payloadToNetwork(Payload *_payload)
{
    
    _payload->size                  = htons(_payload->size);
    _payload->id.head               = htons(_payload->id.head);
    _payload->message.totalSize     = htons(_payload->message.totalSize);
    _payload->message.frameNumber   = htons(_payload->message.frameNumber);
    
}
void networkToPayload(Payload *_payload)
{
    _payload->size                  = ntohs(_payload->size);
    _payload->id.head               = ntohs(_payload->id.head);
    _payload->message.totalSize     = ntohs(_payload->message.totalSize);
    _payload->message.frameNumber   = ntohs(_payload->message.frameNumber);
}

void dumpPayload(Payload *_payload)
{
    printf("\r\n======== dump!!\r\n");
    printf("payload\nsize:%04X\r\n ",_payload->size);
    
    printf("Payload id_head:%04X\r\n personal id:",_payload->id.head);  
    for(int i=0 ; i < sizeof(_payload->id.personalId) ; i++){
        printf("%d:%02X ",i,_payload->id.personalId[i]);
    }
    
    printf("\r\n");
    
    printf("total size:%d , frame number:%d , divece:%0X , command:%02X\r\n"
        ,_payload->message.totalSize
        ,_payload->message.frameNumber
        ,_payload->message.device
        ,_payload->message.command);
    
    printf("message data:\r\n");
    for(int i=0 ; i < sizeof(_payload->message.data) ; i++){
         printf("%d:%02X ",i,_payload->message.data[i]);
    }
    
    printf("\r\n--- RAW DATA -------\r\n");
    for(int i=0 ; i < sizeof(Payload) ; i++){
         printf("%d:%02X ",i,((uint8_t*)_payload)[i]);
    }
    printf("\r\n");
    
}