#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include <stdio.h>
#include <stdlib.h>
#include <string>
#include <wolfssl/ssl.h>
#include <wolfssl/wolfcrypt/error-crypt.h>

#define HTTPD_SERVER_PORT   8090
#define HTTPD_MAX_REQ_LENGTH   5000
#define HTTPD_MAX_HDR_LENGTH   255


DigitalOut ledr(PTB22);
DigitalOut ledg(PTE26);
DigitalIn sw3(PTA4);

char buffer[HTTPD_MAX_REQ_LENGTH+1];

char *uristr;
char *eou;

int lenght;
int start;

int main()
{
    setbuf(stdout, NULL);

    ledg=!ledg;

    printf("Starting TLS Client,...\n");

    EthernetInterface eth;


    //wolfSSL_Debugging_ON();    //Enable WolfSSl Debugging Mode !!Warning: There may occure Problems, because of low RAM (Program Crash)!!


    eth.init(); //Use DHCP
    eth.connect();
    printf("The Board's IP Address is : %s\n\n",eth.getIPAddress());

    TCPSocketServer server;
    TCPSocketConnection client;

    while(1) {


        /*Preparing Server For Upcomming Connections*/

        printf("Trying to bind Port %d to server\n",HTTPD_SERVER_PORT);
        server.bind(HTTPD_SERVER_PORT);
        server.listen();


        while (true) {
            printf("Wait for new connection...\n\n");
            server.accept(client);


            printf("Connection from: %s\r\n", client.get_address());
            while (1) {
                char buffer[HTTPD_MAX_REQ_LENGTH+1];
                int n = client.receive(buffer, sizeof(buffer));
                //printf("Recieved Data: %d\r\n\r\n%.*s\r\n",n,n,buffer); //Check recieved Data


                if (n <= 0) break;

                /*Extracting Recieved Content-Length*/

                for ( int i=0; i<HTTPD_MAX_REQ_LENGTH+1; i++) {
                    if(buffer[i]=='L' && buffer[i+1]=='e' && buffer[i+2]=='n' && buffer[i+3]=='g' && buffer[i+4]=='t' && buffer[i+5]=='h') {

                        char lenghtArray[4];
                        lenghtArray[0] = buffer[i+8];
                        lenghtArray[1] = buffer[i+9];
                        lenghtArray[2] = buffer[i+10];
                        lenghtArray[3] = buffer[i+11];
                        lenght = atoi(lenghtArray);
                        lenght = lenght-6;


                        break;
                    }
                }

                char tokenArray[lenght+1];

                int copy = 0;

                int index = 0;

                /*Checking For An Included Token And Copying It to tokenArray[]*/

                for (int i = 0; i<HTTPD_MAX_REQ_LENGTH+1; i++) {
                    if(buffer[i]=='t' && buffer[i+1]=='o' && buffer[i+2]=='k' && buffer[i+3]=='e' && buffer[i+4]=='n' && buffer[i+5]=='=') {
                        copy = 1;
                        start = i+6;
                    }
                    if(copy == 1) {
                        tokenArray[index] = buffer[start];
                        index++;
                        start++;
                    }
                }

                if (n >= 4096) {
                    char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
                    sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                    client.send(httpHeader,strlen(httpHeader));
                    client.send(buffer,n);
                    break;
                } else {

                    buffer[n]=0;
                }


                if (!strncmp(buffer, "GET ", 4)) {
                    uristr = buffer + 4;
                    eou = strstr(uristr, " ");
                    if (eou == NULL) {
                        char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
                        sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                        client.send(httpHeader,strlen(httpHeader));
                        client.send(buffer,n);
                    } else {
                        *eou = 0;
                    }

                }
                client.close(true);

                free(&buffer);


                /* Post */
                if(copy == 1) {

                    HTTPMap map;
                    HTTPText inText(buffer);
                    HTTPClient http;


                    printf("Token found and trying to send\n\n");

                    map.put("token", tokenArray);
                    printf("\nTrying to post data...\n");

                    HTTPResult ret = http.post("https://136.199.52.150/introspection", map, &inText);   //Posting funktion, including TLS Handshake

                    /* Check the Result */

                    if (ret == HTTP_OK) {
                        printf("Executed POST successfully - read %d characters\n", strlen(buffer));
                        //printf("Result: \n\n%s\n", buffer);

                        /*Checking response for success-message from AS*/

                        for(int i = 0; i < (strlen(buffer)-12); i++) {

                            if(buffer[i]=='a' && buffer[i+1]=='c' && buffer[i+2]=='t' && buffer[i+3]=='i' && buffer[i+4]=='v' && buffer[i+5]=='e' && buffer[i+9]=='t'&& buffer[i+10]=='r'&& buffer[i+11]=='u'&& buffer[i+12]=='e') {

                                ledr =! ledr;
                                ledg =! ledg;

                                wait(5);

                                ledg =! ledg;
                                ledr =! ledr;

                            }
                        }

                        free(&buffer);

                    } else {
                        /*Print HTTP Response Code If Nessesary*/
                        printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
                    }

                    wait(1);

                } else {
                    printf("No Token found\n");

                }
            }
        }

    }
}
