/*
 * Settings.h
 *
 *  Created on: 19/jan/2015
 *      Author: Marcos A. Lucas
 */
 
#ifndef PMEDLOG_H
#define PMEDLOG_H

#include "mbed.h"
#include "Settings.h"

#define LOGFILE  "/local/pmedlog.txt"


//define as constant some log entries
static const char *PMEDLOG_INITIALIZING     = " Initializing Protegemed ... ";
static const char *PMEDLOG_INITIALIZINGWDT  = " Initializing Protegemed by WhatchDog Timer... ";
static const char *PMEDLOG_STARTED          = " Started Protegemed ! ";
static const char *PMEDLOG_WRONGCODE        = " Oops... wrong code, a reset may be expected ";
static const char *PMEDLOG_RESET            = " No reason given ";
static const char *PMEDLOG_DEFAULTS         = " Loaded defaults in Settings ! ";

static const char *PMEDLOG_RESETTELNET      = " by telnet reset ";
static const char *PMEDLOG_UPDATETELNET     = " by telnet update ";

static const char *PMEDLOG_HTTP_CONNECT     = "On HTTP_POST - Connect";
static const char *PMEDLOG_HTTP_SEND        = "On HTTP_POST - Send";

class PmedLog
{

protected:

    static int m_entry;
    static time_t m_lastMark;

public:  

    PmedLog(); 
      
    // Control the marks behavior in log file
    static bool get_LogMarks() { return Settings::get_LogMarks(); }
    static void set_LogMarks(bool value) { Settings::set_LogMarks(value); }
    static int get_LogMarksInterval() { return Settings::get_LogMarksInterval(); }
    static void set_LogMarksInterval(int value) { Settings::set_LogMarksInterval(value); }
    
    static void WriteEntry(const char *value);
    static void Mark();
    
};

#endif //#ifndef PMEDLOGS_H

