/*
 * Settings.cpp
 *
 *  Created on: 19/jan/2015
 *      Author: Marcos A. Lucas
 */

#include "PmedLog.h"

int PmedLog::m_entry = 0;
time_t PmedLog::m_lastMark = 0;

void PmedLog::WriteEntry(const char *value)
{
    time_t seconds = time(NULL);

    char buffer[32];
    strftime(buffer, 32, "%T", localtime(&seconds));

    printf("LOG : %s : %.5d : %s \n", buffer, m_entry, value);

    FILE *f = fopen(LOGFILE,"a");

    if(f == NULL)
    {
        printf("Error creating log file\r\n");
        return;
    }

    fprintf(f, "%s : %.5d : %s\n", buffer, m_entry, value);

    fclose(f);

    m_entry++;
}

void PmedLog::Mark()
{
    if (!get_LogMarks()) return;
    
    time_t seconds = time(NULL);
    time_t difference = seconds - m_lastMark;

    if ( difference >= get_LogMarksInterval() ) {
        m_lastMark = seconds;
        WriteEntry(" . --  ===   MARK   ===  -- . ");
    }
}
