/*
 * Capture.h
 *
 *  Created on: 
 *      Author: 
 */
#include "Capture.h"

Semaphore Capture::m_CaptureSemaphore(1); //used to alert the capture thread about a ready capture 
int Capture::m_BufferIndex;

__attribute((section("AHBSRAM1"),aligned)) dmaLinkedListNode Capture::m_Nodes[2];// __attribute__((section("AHBSRAM0"))); //this list holds the buffer configuration for the DMA peripheral
__attribute((section("AHBSRAM1"),aligned)) unsigned short int Capture::m_AdcBuffers[2][NUMBER_OF_SAMPLES][NUMBER_OF_CHANNELS];// __attribute__((section("AHBSRAM0")));
Serial rfid_serial(p28,p27);

//This function prepares the capture buffers and starts the DMA peripheral
void Capture::Start()
{
    m_Nodes[0].destAddr = (unsigned int)m_AdcBuffers[0];// HERE GOES THE BUFFER ADDRESS(unsigned int)adval;
    m_Nodes[0].sourceAddr = (unsigned int)&LPC_ADC->ADGDR;
    m_Nodes[0].dmaControl = (NUMBER_OF_SAMPLES*NUMBER_OF_CHANNELS)| DMA_DST_WIDTH_HALFWORD | DMA_SRC_WIDTH_HALFWORD | DMA_DST_INCREMENT | DMA_TC_INT;
    m_Nodes[0].nextNode = (unsigned int)&m_Nodes[1];

    m_Nodes[1].destAddr = (unsigned int)m_AdcBuffers[1];// HERE GOES THE BUFFER ADDRESS(unsigned int)adval2;
    m_Nodes[1].sourceAddr = (unsigned int)&LPC_ADC->ADGDR;
    m_Nodes[1].dmaControl = (NUMBER_OF_SAMPLES*NUMBER_OF_CHANNELS)| DMA_DST_WIDTH_HALFWORD | DMA_SRC_WIDTH_HALFWORD | DMA_DST_INCREMENT | DMA_TC_INT;
    m_Nodes[1].nextNode = (unsigned int)&m_Nodes[0];

    m_BufferIndex=0;

    while(!(LPC_ADC->ADDR0&(1U<<31)));  //waits the completion of the ADC Channel 0 capture - for synchronization purposes
    while(!(LPC_ADC->ADDR0&(1U<<31)));  //waits the completion of the ADC Channel 0 capture - for synchronization purposes

    setup_channel(&m_Nodes[0],0,DMA_PERIPHERAL_ADC,DMA_MEMORY);
}

//This function initializes the ADC and DMA peripherals
void Capture::Initialize()
{   
    //printf("0x%lx\n",  LargeBuffer);
    init_adc(FREQBASE*NUMBER_OF_SAMPLES*NUMBER_OF_CHANNELS);
    select_channels(ADC_CH_0|ADC_CH_1|ADC_CH_2|ADC_CH_3|ADC_CH_4|ADC_CH_5);
    LPC_ADC->ADCR |= ADC_MODE_BURST;

    init_dma();
    
    Start();
    
    m_CaptureSemaphore.wait();
}

void Capture::Stop()
{
    m_CaptureSemaphore.release();   //release semaphore
    stop_channel();
}

void Capture::Wait()
{
    m_CaptureSemaphore.wait(osWaitForever);
}

unsigned short int Capture::GetValue(int nsamples, int nchannel)
{
    return ADC_CONVERT(m_AdcBuffers[m_BufferIndex][nsamples][nchannel]);
}

void Capture::CopyBuffer(int channel, short int *dest)
{
    for(int i=0;i<NUMBER_OF_SAMPLES;i++)
    {
        dest[i] = GetValue(i,channel);
    }
}


void Capture::CopyBufferFloat(int channel, float *dest)
{
    for(int i=0;i<NUMBER_OF_SAMPLES;i++)
    {
        dest[i] = (float) GetValue(i,channel);
    }
}

//DMA ISR signals the capture thread about the end of capture event
extern "C" void DMA_IRQHandler(void)
{
    Capture::ISRHandler();
}

void Capture::ISRHandler()
{
    Capture::m_BufferIndex = (~Capture::m_BufferIndex)&1;

    Capture::m_CaptureSemaphore.release();
    LPC_GPDMA->DMACIntTCClear = 0xFF;
}
/*
bool Capture::ReadRFID(int channel,char *rfid)
{
    
    char cmd[4];
    cmd[0] = 'S';
    cmd[1] = '0'+channel;
    cmd[2] = '\n';
    cmd[3] = '\0';
    
    //send
    rfid_serial.puts(cmd);
    
    //receive
    char ch=0;
    char ans[10];
    int cnt=0;
    int tmout=1000;
    while(ch != '\n' && tmout-- && cnt<9)
    {
        if(rfid_serial.readable())
        {
            ch = rfid_serial.getc();
            if(!((ch>='0' && ch<='9') || (ch >= 'A' && ch <= 'F')))ch='0';
            ans[cnt++] = ch;
        }
        else
            wait_ms(1);
        
    }
    if (cnt > 0){
        ans[cnt-1] = '\0';
        for(int i=0;i<10;i++)
            rfid[i] = ans[i];
        return true;
    }
    return false;
    
}
*/

void Capture::ReadRFID(int channel,char *rfid)
{
    
    char cmd[4];
    cmd[0] = 'S';
    cmd[1] = '0'+channel;
    cmd[2] = '\n';
    cmd[3] = '\0';
    
    //send
    rfid_serial.puts(cmd);
    
    //receive
    char ch=0;
    char ans[10];
    int cnt=0;
    int tmout=1000;
    while(ch != '\n' && tmout-- && cnt<9)
    {
        if(rfid_serial.readable())
        {
            ch = rfid_serial.getc();
            if(!((ch>='0' && ch<='9') || (ch >= 'A' && ch <= 'F')))ch='0';
            ans[cnt++] = ch;
        }
        else
            wait_ms(1);
        
    }
    ans[cnt-1] = '\0';
    for(int i=0;i<9;i++)
        rfid[i] = ans[i];
    
}