/*
 * EventDetector.h
 *
 *  Created on: 
 *      Author: 
 */
 
#ifndef EVENTDETECTOR_H
#define EVENTDETECTOR_H

#include <stdlib.h>

#include "rtos.h"

#include "Settings.h"
#include "Capture.h"
#include "SignalProcessor.h"

class CaptureEvent
{
    char  m_RFID[9];
    int   m_Type;
    int   m_OutletNumber;
    float m_MeanValue;
    float m_MV2;
    float m_RMSValue;    
    int   m_Under;
    int   m_Over;
    float m_Gain;
    int   m_Offset;
    int   m_Duration;
    short int m_Samples[NUMBER_OF_SAMPLES];
    
public:
    
    CaptureEvent();
    
    //void Setup(char* rfid,int type,int outlet,float mv,float rms,float gain, int offset,float* sin, float* cos);    
    void Setup(char* rfid, int type, int outlet, float mv, float mv2, float rms, int under, int over, float gain, int offset, int duration, short int *samples);    
        
    char* get_RFID() { return m_RFID; }
    int get_Type() { return m_Type; }
    int get_OutletNumber() { return m_OutletNumber; }
    float get_MeanValue() { return m_MeanValue; }
    float get_MV2() { return m_MV2; }
    float get_RMSValue() { return m_RMSValue; }
    int get_Under() { return m_Under; }
    int get_Over() { return m_Over; }
    float get_Gain() { return m_Gain; }
    int get_Offset() { return m_Offset; }
    int get_Duration() { return m_Duration; }
    short int get_SampleValue(int idx) { return m_Samples[idx];}
};

typedef Mail<CaptureEvent,LENGTH_MAIL_BOX> CaptureMailbox;

class EventDetector
{
protected:

    static CaptureMailbox m_EventMailbox;
    static const int m_EventLimit;
    
    static EventDetector m_Detector[NUMBER_OF_CHANNELS];

    bool m_OutletTriggered;
    int m_EventCounter;
    int m_Channel;
    Timer m_tempo;    
    
    //void SendMessage(int ext,float rmsvalue);
    void SendMessage(int ext, short int *buf, float rmsvalue, float mv2, int under, int over, int duration);
    
    int TimeDelay(int t);
        
public:

    EventDetector(int ch);
    
    void ExternalTrigger();
    
    //void ProcessEvent(float rmsvalue, int t);
    void ProcessEvent(float rmsvalue, float mv2, int under, int over);
    
    void ShowValues(CaptureEvent* e);
    
    static CaptureMailbox& GetMailbox() { return m_EventMailbox; }
    static EventDetector& get_Detector(int ch) { return m_Detector[ch]; }
    
};

#endif