/*
 * adc.h
 *
 *  Created on: 02/07/2011
 *      Author: francisco
 */

#ifndef ADC_H_
#define ADC_H_


#define PCADC   (1U<<12)

#define ADC_CCLK_4      0U
#define ADC_CCLK        1U
#define ADC_CCLK_2      2U
#define ADC_CCLK_8      3U

#define PCLK_ADC        24U

#define     ADC_CH_0                        (1U<<0)
#define     ADC_CH_1                        (1U<<1)
#define     ADC_CH_2                        (1U<<2)
#define     ADC_CH_3                        (1U<<3)
#define     ADC_CH_4                        (1U<<4)
#define     ADC_CH_5                        (1U<<5)
#define     ADC_CH_6                        (1U<<6)
#define     ADC_CH_7                        (1U<<7)
#define     ADC_CLKDIV(val)                 ((val)<<8)
#define     ADC_MODE_BURST                  (1U<<16)
#define     ADC_OPERATIONAL                 (1U<< 21)
#define     ADC_NO_START                    ~(7U<<24)
#define     ADC_START_NOW                   (1U<<24)
#define     ADC_START_ON_PIO2_10            (2U<<24)
#define     ADC_START_ON_PIO1_27            (3U<<24)
#define     ADC_START_ON_MAT0_1             (4U<<24)
#define     ADC_START_ON_MAT0_3             (5U<<24)
#define     ADC_START_ON_MAT1_0             (6U<<24)
#define     ADC_START_ON_MAT1_1             (7U<<24)
#define     ADC_EDGE_FALLING                (1U<<27)
#define     ADC_EDGE_RAISING                ~(1U<<27)

#define     ADC_GLOBAL_INT                  (1U<<8)
#define     ADC_INT_CH_0                    (1U<<0)
#define     ADC_INT_CH_1                    (1U<<1)
#define     ADC_INT_CH_2                    (1U<<2)
#define     ADC_INT_CH_3                    (1U<<3)
#define     ADC_INT_CH_4                    (1U<<4)
#define     ADC_INT_CH_5                    (1U<<5)
#define     ADC_INT_CH_6                    (1U<<6)
#define     ADC_INT_CH_7                    (1U<<7)

#define     ADC_LAST_CONVERSION()           ((LPC_ADC->ADGDR&(0xFFFU<<4))>>4)
#define     ADC_LAST_CONVERSION_CHANNEL()   ((LPC_ADC->ADGDR&(7U<<24))>>24)
#define     ADC_LAST_CONVERSION_DONE()      (LPC_ADC->ADGDR&(1U<<31))
#define     ADC_LAST_CONVERSION_OVERUN()    (LPC_ADC->ADGDR&(1U<<30))
#define     ADC_CONVERSION_CH(ch)           ((LPC_ADC->ADDR[ch]&(0xFFFU<<4))>>4)
#define     ADC_CONVERSION_DONE_CH(ch)      (LPC_ADC->ADDR[ch]&(1U<<31))
#define     ADC_CONVERSION_OVERUN_CH(ch)    (LPC_ADC->ADDR[ch]&(1U<<30))

#define     ADC_CONVERT(val)                ((val&(0xFFFU<<4))>>4)
#define     ADC_CHANNEL(val)                ((val&(7U<<24))>>24)

#ifdef __cplusplus
extern "C" {
#endif

extern void init_adc(int adc_clk);
extern void setup_start(int mode,int edge);
extern void select_channels(int adc_ch);

#ifdef __cplusplus
}
#endif

#endif /* ADC_H_ */
