#include "TelnetServer.h"

#include "Settings.h"

char *wrong_args_msg_set = "Wrong number of arguments.\r\n\r\nUsage: setparam <parameter name> <parameter value>\r\n";
char *param_not_found_msg_set = "Parameter not found.\r\n\r\n";
char *bad_argument_set = "The parameter supplied does not have a valid format.\r\n\r\n";

int TelnetServer::SetParamCommand(TCPSocketConnection *conn,char** argv,int argc)
{

    if(argc != 3)
    {
        conn->send(wrong_args_msg_set,strlen(wrong_args_msg_set));
        return 0;
    }


    if(!strcmp(argv[1],"Ipserver"))
    {
        ip_addr_t addr;
        if(ipaddr_aton(argv[2],&addr) != ERR_OK)
        {
            conn->send(bad_argument_set,strlen(bad_argument_set));
        }
        else
        {
            Settings::set_ServerUrl(argv[2]);
            Settings::WriteFile();
        }
        return 0;
    }
 
    if(!strcmp(argv[1],"Ipaddress"))
    {
        ip_addr_t addr;
        if(ipaddr_aton(argv[2],&addr) != ERR_OK)
        {
            conn->send(bad_argument_set,strlen(bad_argument_set));
        }
        else
        {
            Settings::set_IpAddress(argv[2]);
            Settings::WriteFile();
        }
        return 0;
   } 
    
    if(!strcmp(argv[1],"module"))
    {
        Settings::set_ModuleNumber(atoi(argv[2]));
        Settings::WriteFile();
        return 0;
    }

    /* Pega os números das tomadas [0..2]*/
    int i;
    for(i=0;i<3;i++)
    {
        char b[12];
        sprintf(b,"outlet%d",i);
        if(!strcmp(argv[1],b))
        {
            Settings::set_Outlet(i,atoi(argv[2]));
            Settings::WriteFile();
            return 0;
        }
    }
    /* Pega os canais, de 0..5 */
    for(i=0;i<6;i++)
    {
        char b[12];
        sprintf(b,"gain%d",i);
        if(!strcmp(argv[1],b))
        {
            Settings::set_Gain(i,atof(argv[2]));
            Settings::WriteFile();
            return 0;
        }

        sprintf(b,"offset%d",i);
        if(!strcmp(argv[1],b))
        {
            Settings::set_Offset(i,atoi(argv[2]));
            Settings::WriteFile();
            return 0;
        }

        sprintf(b,"limit%d",i);
        if(!strcmp(argv[1],b))
        {
            Settings::set_Limit(i,atof(argv[2]));
            Settings::WriteFile();
            return 0;
        }

        sprintf(b,"outlet_number%d",i);
        if(!strcmp(argv[1],b))
        {
            Settings::set_OutletNumber(i,atoi(argv[2]));
            Settings::WriteFile();
            return 0;
        }

        sprintf(b,"purpose%d",i);
        if(!strcmp(argv[1],b))
        {
            Settings::set_Purpose(i,argv[2][0]);
            Settings::WriteFile();
            return 0;
        }
    }

/*    
    if(!strcmp(argv[1],"Samples"))
    {
        Settings::set_Samples(atoi(argv[2]));
        Settings::WriteFile();
        return 0;
    }
*/    
    if(!strcmp(argv[1],"EventLimit"))
    {
        Settings::set_EventLimit(atoi(argv[2]));
        Settings::WriteFile();
        return 0;
    }
    
    if(!strcmp(argv[1],"LogMarksInterval"))
    {
        int value = atoi(argv[2]);
        if ( ! ( value > 0 ) ) {
            conn->send(bad_argument_set,strlen(bad_argument_set));
            return 0;
        }
        Settings::set_LogMarksInterval(atoi(argv[2]));
        Settings::WriteFile();
        return 0;
    }

    if(!strcmp(argv[1],"LogMarks"))
    {
        if ( strcmp(argv[2],"true") == 0 )  {
            Settings::set_LogMarks(true);
        } else {
            Settings::set_LogMarks(false);
        }
        Settings::WriteFile();
        return 0;
    }

    conn->send(param_not_found_msg_set,strlen(param_not_found_msg_set));
    return 0;

}