#include "TelnetServer.h"

#include "Settings.h"

 char *wrong_args_msg_get = "Wrong number of arguments.\r\n\r\nUsage: getparam <parameter name>\r\n";
 char *param_not_found_msg_get = "Parameter not found.\r\n\r\n";

int TelnetServer::GetParamCommand(TCPSocketConnection *conn,char** argv,int argc)
{

    if(argc != 2)
    {
        conn->send(wrong_args_msg_get,strlen(wrong_args_msg_get));
        return 0;
    }

    printf("Getting parameter %s\n", argv[1]);

    if(!strcmp(argv[1],"Ipserver"))
    {
        conn->send("\r\nIpserver=",strlen("\r\nIpserver="));
        conn->send(Settings::get_ServerUrl(),strlen(Settings::get_ServerUrl()));
        conn->send("\r\n",strlen("\r\n"));
        return 0;
    }
    
    if(!strcmp(argv[1],"Ipaddress"))
    {
        conn->send("\r\nIpaddress=",strlen("\r\nIpaddress="));
        conn->send(Settings::get_IpAddress(),strlen(Settings::get_IpAddress()));
        conn->send("\r\n",strlen("\r\n"));
        return 0;
    }

    if(!strcmp(argv[1],"module"))
    {
        char b[12];
        conn->send("\r\nmodule=",strlen("\r\nmodule="));
        sprintf(b,"%d\r\n",Settings::get_ModuleNumber());
        conn->send(b,strlen(b));
        return 0;
    }
        
    /* Pega os numeros das tomadas [0..2]*/
    int i;
    for(i=0;i<NUMBER_OF_OUTLETS;i++)
    {
        char b[12];
        sprintf(b,"outlet%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\noutlet%d=%d\r\n",i,Settings::get_Outlet(i));
            conn->send(b,strlen(b));
            return 0;
        }
    }
    /* pega os dados dos canais [0..5] */
    for(i=0;i<NUMBER_OF_CHANNELS;i++)
    {
        char b[12];
        sprintf(b,"gain%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\ngain%d=%f\r\n",i,Settings::get_Gain(i));
            printf("Getting gain\n");
            conn->send(b,strlen(b));
            return 0;
        }

        sprintf(b,"offset%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\noffset%d=%d\r\n",i,Settings::get_Offset(i));
            conn->send(b,strlen(b));
            return 0;
        }

        sprintf(b,"limit%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\nlimit%d=%f\r\n",i,Settings::get_Limit(i));
            conn->send(b,strlen(b));
            return 0;
        }
                
        sprintf(b,"outlet_number%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\noutlet_number%d=%d\r\n",i,Settings::get_OutletNumber(i));
            conn->send(b,strlen(b));
            return 0;
        }

        sprintf(b,"purpose%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\npurpose%d=%c\r\n",i,Settings::get_Purpose(i));
            conn->send(b,strlen(b));
            return 0;
        }
    }

/*    
    if(!strcmp(argv[1],"Samples"))
    {
        char b[12];
        conn->send("\r\nSamples=",strlen("\r\nSamples="));
        sprintf(b,"%d\r\n",NUMBER_OF_SAMPLES);
        conn->send(b,strlen(b));
        return 0;
    }
*/    
    if(!strcmp(argv[1],"EventLimit"))
    {
        char b[12];
        conn->send("\r\nEventLimit=",strlen("\r\nEventLimit="));
        sprintf(b,"%d\r\n",Settings::get_EventLimit());
        conn->send(b,strlen(b));
        return 0;
    }

    conn->send(param_not_found_msg_get,strlen(param_not_found_msg_get));
    return 0;

}
