/*
 * Http_post.cpp
 *
 *  Created on: 
 *      Author: 
 */
#include "Http_post.h"
#include "Pmed_reset.h"

void HttpPost::HttpPost_Thread(void const *arg)
{
    printf("HTTP POST Thread starting...\r\n");    
    
    //inicializar socket
   // TCPSocketConnection sock;
    
    CaptureMailbox& mbox = EventDetector::GetMailbox();
    
    osEvent evt;
    //printf("aqui\n");
    while(1)
    {
        TCPSocketConnection sock;
        //printf("Esperando Evento\n");
        evt = mbox.get();

        if(evt.status == osEventMail)
        {
            //printf("Recebido osEventMail...\n ");
            tranca.wait();
            CaptureEvent* cap = (CaptureEvent*)evt.value.p;
            //printf("Pegou evento\n");
            DoPost(sock,Settings::get_ServerUrl(),cap);    
            mbox.free(cap);
            tranca.release();
            //printf("Enviado e Liberado Mbox ...\n ");
            //sock.reset_address();
        }
        //Thread::yield();
    }
}



void HttpPost::DoPost(TCPSocketConnection sock, char *host, CaptureEvent* dados){
    char *http_cmd; 
    int escritos, r=-1, i;

    http_cmd = (char *) malloc(1800);
    
    if (http_cmd == NULL)
        printf("Sem memoria\n");

    memset(http_cmd, 0, 1800);
    
    PreparePost( dados,http_cmd );
    
    //printf("Tamanho do comando %d\n", strlen(http_cmd));
    //printf("Comando: /* %s */\n", http_cmd);
    
    
    
    for(i=0; i < MAXTRIES; i++){
        r = sock.connect(host, 80);        
        if (r < 0) {
            printf("Error: Unable to connect to (%s) on port (%d) Try %d\n", host, 80, i);
            Thread::wait(Settings::get_DelayTry());
        }
        else
            break;            
    }     
    if (r == 0){
        for(i=0; i < MAXTRIES; i++){
            escritos = sock.send_all(http_cmd, strlen(http_cmd));        
            if(escritos != strlen(http_cmd)){
                printf("Erro ao gravar no socket HTTP!! Escritos %d\t Tam %d Try %d\n", escritos, strlen(http_cmd), i);            
                Thread::wait(Settings::get_DelayTry());
            }
            else 
                break;
        }
        if ( i != MAXTRIES )
            Thread::wait(Settings::get_DelaySend());
        else{
            //printf("Reset\n");
                
            Pmed_reset(PMEDLOG_HTTP_CONNECT);
        }                    
            
        //Codigo para buscar o retorno do servidor HTTP
        /*
        printf("Vai pegar retorno\n");
        
        char buffer[300];
        int ret;
        while (true) {
            ret = sock.receive(buffer, sizeof(buffer)-1);
            if (ret <= 0)
                break;
            buffer[ret] = '\0';
            printf("Received %d chars from server:\n%s\n", ret, buffer);
        }
        */        
    }
    else{
        printf("Reset\n");
            
        Pmed_reset(PMEDLOG_HTTP_SEND);
    }
    
    sock.close(); 
    free(http_cmd); 
    
}

void HttpPost::PreparePost(CaptureEvent* dados,char *strfinal){    
    char aux[20];
    int i, ContentLen = 1662;

    const char *header1 = "POST /capturesfft.php HTTP/1.1\r\n";
                //"Host: 192.168.1.26\r\n"
                //"Content-Length: "
                
    const char *header2 = "\r\n"
                "Content-Type: application/x-www-form-urlencoded\r\n"
                "\r\n";
    
    //str = (char *) malloc(450);
    //strfinal = (char *) malloc(450);
    //memset(str,0,400);
    //memset(strfinal,0,500);
            
    strcat(strfinal, header1);    
    strcat(strfinal, "Host: ");
    strcat(strfinal, Settings::get_ServerUrl() );
    strcat(strfinal, "\r\n");
    
    sprintf(aux,"%d",ContentLen);        
    
    strcat(strfinal, "Content-Length: ");
    strcat(strfinal, aux);
    strcat(strfinal, header2);                      
    
    sprintf(aux,"TYPE=%02d",dados->get_Type());
    strcat(strfinal, aux);
    //ContentLen += 7;
    
    sprintf(aux,"&OUTLET=%03d",dados->get_OutletNumber());
    strcat(strfinal, aux);
    //ContentLen += 11;
    
    sprintf(aux,"&RFID=%s", dados->get_RFID());
    strcat(strfinal,aux);
    //ContentLen += 14;

    sprintf(aux,"&OFFSET=%04d",dados->get_Offset());
    strcat(strfinal,aux);
    //ContentLen += 12;
    
    float f = dados->get_Gain();
    sprintf(aux,"&GAIN=%08X", *(unsigned int*)&f);
    strcat(strfinal,aux);
    //ContentLen += 14;
    
    f = dados->get_RMSValue();
    sprintf(aux,"&RMS=%08X",*(unsigned int*)&f);
    strcat(strfinal,aux);
    //ContentLen += 13;
    
    f = dados->get_MeanValue();
    sprintf(aux,"&MV=%08X",*(unsigned int*)&f);
    strcat(strfinal,aux);
    //ContentLen += 12;        
       
    sprintf(aux,"&UNDER=%04d",dados->get_Under());
    strcat(strfinal,aux);
    //ContentLen += 11; 
    
    sprintf(aux,"&OVER=%04d",dados->get_Over());
    strcat(strfinal,aux);
    //ContentLen += 10;        
    
    sprintf(aux,"&DURATION=%04d",dados->get_Duration());
    strcat(strfinal,aux);
    //ContentLen += 14;                        
    
    char s[7];        
    strcat(strfinal,"&SAMPLES=");
       
    for(i=0;i<NUMBER_OF_SAMPLES;i++)
    {   
        sprintf(s,"%05d",dados->get_SampleValue(i));     
        
        strcat(strfinal,s);        
        if (i < (NUMBER_OF_SAMPLES - 1))
            strcat(strfinal, ";");                    
    }    
        
    strcat(strfinal,"\r\n");            
    
    //printf("Request=[%s]\n",strfinal);    
    //printf("Tamanho STRFINAL %d\n", strlen(strfinal));       
 }