/*
 * Capture.h
 *
 *  Created on: 
 *      Author: 
 */
#include "Capture.h"

//Semaphore Capture::m_CaptureSemaphore(1); //used to alert the capture thread about a ready capture 
//int Capture::m_BufferIndex;

//__attribute((section("AHBSRAM1"),aligned)) dmaLinkedListNode Capture::m_Nodes[2];// __attribute__((section("AHBSRAM0"))); //this list holds the buffer configuration for the DMA peripheral
__attribute((section("AHBSRAM1"),aligned)) short int Capture::m_AdcBuffers[NUMBER_OF_CHANNELS][NUMBER_OF_SAMPLES];// __attribute__((section("AHBSRAM0")));
Serial rfid_serial(p28,p27);

AnalogIn AdcChannel0(CHANNEL0);
AnalogIn AdcChannel1(CHANNEL1);
AnalogIn AdcChannel2(CHANNEL2);
AnalogIn AdcChannel3(CHANNEL3);
AnalogIn AdcChannel4(CHANNEL4);
AnalogIn AdcChannel5(CHANNEL5);

//ADC_CONVERT(m_AdcBuffers[m_BufferIndex][nsamples][nchannel]);

short int Capture::GetValue(int nsamples, int nchannel)
{
    return m_AdcBuffers[nchannel][nsamples];
}

void Capture::PutValue(int nsamples, int nchannel, short int value)
{
    m_AdcBuffers[nchannel][nsamples] = value;
}

void Capture::CopyBuffer(int channel, short int *dest)
{
    memcpy(dest, &m_AdcBuffers[channel][0], sizeof(short int) * NUMBER_OF_SAMPLES);
    /*
    for(int i=0;i<NUMBER_OF_SAMPLES;i++)
    {
        dest[i] = GetValue(i,channel);
    }
    */
}


void Capture::AcquireValues(){
    int i;
    
    for(i=0; i < NUMBER_OF_SAMPLES; i++){
         m_AdcBuffers[0][i] = ADC_CONVERT(AdcChannel0.read_u16());
         //wait_us(10);
         m_AdcBuffers[1][i] = ADC_CONVERT(AdcChannel1.read_u16());
         //wait_us(10);
         m_AdcBuffers[2][i] = ADC_CONVERT(AdcChannel2.read_u16());
         //wait_us(10);
         m_AdcBuffers[3][i] = ADC_CONVERT(AdcChannel3.read_u16());
         //wait_us(10);
         m_AdcBuffers[4][i] = ADC_CONVERT(AdcChannel4.read_u16());
         //wait_us(10);
         m_AdcBuffers[5][i] = ADC_CONVERT(AdcChannel5.read_u16());
         wait_us(13);
    }    
}

//void Capture::Initialize(){     //AnalogIn adcChannel0; }


void Capture::ReadRFID(int channel,char *rfid)
{
    
    char cmd[4];
    cmd[0] = 'S';
    cmd[1] = '0'+channel;
    cmd[2] = '\n';
    cmd[3] = '\0';
    
    //send
    rfid_serial.puts(cmd);
    
    //receive
    char ch=0;
    char ans[10];
    int cnt=0;
    int tmout=1000;
    while(ch != '\n' && tmout-- && cnt<9)
    {
        if(rfid_serial.readable())
        {
            ch = rfid_serial.getc();
            if(!((ch>='0' && ch<='9') || (ch >= 'A' && ch <= 'F')))ch='0';
            ans[cnt++] = ch;
        }
        else
            wait_ms(1);
        
    }
    ans[cnt-1] = '\0';
    for(int i=0;i<9;i++)
        rfid[i] = ans[i];
    
}