/*
 * limites.c
 *
 *  Created on: 20/07/2014
 *      Author: rebonatto
 */

#include "limites.h"


// These external symbols are maintained by the linker to indicate the
// location of various regions in the device's memory.  They will be used by
// DisplayRAMBanks() to dump the size of each RAM bank to stdout.

extern unsigned int Image$$RW_IRAM1$$Base;
extern unsigned int Image$$RW_IRAM1$$ZI$$Limit;
extern unsigned int Image$$RW_IRAM2$$Base;
extern unsigned int Image$$RW_IRAM2$$ZI$$Limit;
extern unsigned int Image$$RW_IRAM3$$Base;
extern unsigned int Image$$RW_IRAM3$$ZI$$Limit;
 
 
// Displays the size of static allocations for each RAM bank as indicated by
// ARM linker to stdout.
void DisplayRAMBanks(void)
{
    printf("Static RAM bank allocations\r\n");
    printf("  Main RAM = %u\r\n", (unsigned int)&Image$$RW_IRAM1$$ZI$$Limit - 
                                  (unsigned int)&Image$$RW_IRAM1$$Base);
    printf("  RAM0     = %u\r\n", (unsigned int)&Image$$RW_IRAM2$$ZI$$Limit -
                                  (unsigned int)&Image$$RW_IRAM2$$Base);
    printf("  RAM1     = %u\r\n", (unsigned int)&Image$$RW_IRAM3$$ZI$$Limit -
                                  (unsigned int)&Image$$RW_IRAM3$$Base);
}
