#include "TftpServer.h"

#include <stdio.h>

/*
 *
 * TFTP Formats


Type   Op #     Format without header
       2 bytes    string   1 byte     string   1 byte
       -----------------------------------------------
RRQ/  | 01/02 |  Filename  |   0  |    Mode    |   0  |
WRQ    -----------------------------------------------
       2 bytes    2 bytes       n bytes
       ---------------------------------
DATA  | 03    |   Block #  |    Data    |
       ---------------------------------
       2 bytes    2 bytes
       -------------------
ACK   | 04    |   Block #  |
       --------------------
       2 bytes  2 bytes        string    1 byte
       ----------------------------------------
ERROR | 05    |  ErrorCode |   ErrMsg   |   0  |
       ----------------------------------------


    Listen to UDP port 69

    On receive RRQ: Opens the file with semihosting
    Send the file

    On receive WRQ: Open the file with semihosting
    Send Ack
    Receive Data Packet and write into the file
    Send Ack
 *
 */
 
 //LocalFileSystem local("local");
 
/*
static const char* file_not_found_msg = "\x00\x05\x00\x01\File not found.\x00";          //20
static const char* file_too_big_msg = "\x00\x05\x00\x03\File is too big (>512kB).\x00";    //30
static const char* file_already_exists_msg = "\x00\x05\x00\x06\File already exists.\x00";  //25
static const char* file_unknown_error_msg = "\x00\x05\x00\x00Unable to open the file for write.\x00";   //40
*/

char* file_not_found_msg = "\x00\x05\x00\x01\File not found.\x00";          //20
char* file_too_big_msg = "\x00\x05\x00\x03\File is too big (>512kB).\x00";    //30
char* file_already_exists_msg = "\x00\x05\x00\x06\File already exists.\x00";  //25
char* file_unknown_error_msg = "\x00\x05\x00\x00Unable to open the file for write.\x00";   //40


void TftpServer::TftpServerThread(void const *arg)
{
/*
    printf("TFTP Thread starting...\n");
    
    UDPSocket server;
    
    server.bind(69,NULL);
    
    while(1)
    {
        char *buffer = NULL;
        int length = 0;
        Endpoint remote;
        if(server.receiveFrom(remote,&buffer,&length) == ERR_OK)
        {
            printf("Received %d bytes from %s:%d\n",length,remote.get_address(),remote.get_port());
            if(length > 2)
            {
                unsigned short int opcode = buffer[0]*0x100 + buffer[1];
                printf("Got opcode [%X]\n",opcode);
                if(opcode == 1)
                {
                    TftpDoRead(remote,buffer,length);
                }
                else if(opcode == 2)
                {
                    TftpDoWrite(remote,buffer,length);
                }
                delete buffer;
            }
        }
    } 
*/
}

void TftpServer::TftpDoRead(Endpoint remote,char *buffer,int length)
{
/*
    char *filename = buffer+2;
    
    UDPSocket conn;
    
    if(conn.connect(remote.get_address(),remote.get_port()) != ERR_OK)
        return;
    
    char fullpath[256];
    strcpy(fullpath,"/local/");
    strcat(fullpath,filename);
    printf("File = %s\n",fullpath);    
    FILE *f = fopen(fullpath,"rb");
    
    char *ans=NULL;
    int len=0;
    
    if(f == NULL)
    {
        conn.send((char*)file_not_found_msg,20);
        conn.receive(&ans,&len);
        delete ans;
        return;
    }
    
    int idx = 1;

    int readbytes;
    unsigned char *hdrptr = new unsigned char[516];
    unsigned char *dataptr = hdrptr+4;
    
    do
    {
        //opcode
        hdrptr[0] = 0;
        hdrptr[1] = 3;
        //block #
        hdrptr[2] = idx/0x100;
        hdrptr[3] = idx%0x100;
        
        readbytes = fread(dataptr,1,512,f);
        conn.send((char*)hdrptr,readbytes+4);
        conn.receive(&ans,&len);
        delete ans;
        idx++;
    }
    while(readbytes == 512);
    
    fclose(f);
    delete hdrptr;
*/        
}

void TftpServer::TftpDoWrite(Endpoint remote,char *buffer,int length)
{
/*
    char *filename = buffer+2;
    
    UDPSocket conn;
    err_t e;
    if((e=conn.connect(remote.get_address(),remote.get_port())) != ERR_OK)
    {
        printf("Connect error %d\n",e);
        return;
    }
    
    char fullpath[256];
    strcpy(fullpath,"/local/");
    strcat(fullpath,filename);
    printf("File = %s\n",fullpath);    
    
    char *ans=NULL;
    int len=0;
    
    FILE *f = fopen(fullpath,"rb");
    if(f != NULL)
    {
        conn.send((char*)file_already_exists_msg,25);
        //conn.receive(&ans,&len);
        fclose(f);
        delete ans;
        return;
    }
    
    f = fopen(fullpath,"wb");
    if(f == NULL)
    {
        conn.send((char*)file_unknown_error_msg,40);
        //conn.receive(&ans,&len);
        delete ans;
        return;
    }
    
    //int buflen;
    unsigned char ack[4];
    ack[0] = 0;
    ack[1] = 4;
    ack[2] = 0;
    ack[3] = 0;
    
    conn.send((char*)ack,4);
    int error_tries = 5;
    char *buf = NULL;
    
    do
    {
        
        if(conn.receive(&buf,&len) != ERR_OK)
        {
            printf("Error\n");
            error_tries--;
            if(error_tries == 0)
            {
                return;
            }
            conn.send((char*)ack,4);
            continue;
        }
        
        error_tries = 5;
        int idx = buf[2]*0x100 + buf[3];
        
        printf("Len = %d, Idx = %d\n",len,idx);
        
        fwrite(buf+4,1,len-4,f);
        
        delete buf;
        
        if(idx >= 1024)
        {
            conn.send((char*)file_too_big_msg,30);
            //conn.receive(&ans,&len);
            delete ans;
            return;
        }
        
        ack[2] = idx/0x100;
        ack[3] = idx%0x100;
        conn.send((char*)ack,4);
    }
    while(len == 516);
    
    fclose(f);
    */
}