/*
 * Settings.cpp
 *
 *  Created on: 
 *      Author: 
 */

#include "Settings.h"

LocalFileSystem local("local");

char* Settings::m_ipaddress = NULL;
char* Settings::m_netmask = NULL;
char* Settings::m_gateway = NULL;
char* Settings::m_serverurl = NULL;
int  Settings::m_dhcp = 0;
int  Settings::m_ReadRfid = 0;
int  Settings::m_module_number = 0;
//int  Settings::m_MaxChannels = 0;
//int  Settings::m_MaxOutlets = 0;
//int  Settings::m_FreqBase = 0;
//int  Settings::m_Samples = 0;
int  Settings::m_MaxHarmonics = 0;
int  Settings::m_EventLimit = 0;
int  Settings::m_MBoxLength = 0;
//int  Settings::m_NumNeighbors = 0;
//int  Settings::m_PortTCP = 0;
//int  Settings::m_MaxTries = 0;
int  Settings::m_DelayTry = 0;
int  Settings::m_DelaySend = 0;

bool Settings::m_logMarks = true;
int Settings::m_logMarksInterval = 40;

//TCPSocketServer Settings::m_ServerSocket;
//TCPSocketConnection Settings::m_Socket[NEIGHBORS];

float Settings::m_gain[NUMBER_OF_CHANNELS];
int Settings::m_offset[NUMBER_OF_CHANNELS];
float Settings::m_limit[NUMBER_OF_CHANNELS];
int Settings::m_outlet_number[NUMBER_OF_CHANNELS];
char Settings::m_purpose[NUMBER_OF_CHANNELS];
int Settings::m_outlet[NUMBER_OF_OUTLETS];
//char *Settings::m_Neighbor[NEIGHBORS];

void Settings::LoadDefaults()
{   
    set_ServerUrl("192.168.1.26");
    
    set_IpAddress("192.168.1.100");
    
    set_Netmask("255.255.255.0");
    set_Gateway("192.168.1.5");
   
    set_Dhcp(1);
    set_ReadRfid(1);   // default read RFID

    set_ModuleNumber(1);
//    set_MaxChannels(NUMBER_OF_CHANNELS);
//    set_MaxOutlets(NUMBER_OF_OUTLETS);
//    set_FreqBase(60);
//    set_Samples(256);
    set_MaxHarmonics(12);
    set_EventLimit(3);
    set_MBoxLength(10);
//    set_NumNeighbors(3);
//    set_PortTCP(7890);
//    set_MaxTries(10);
    set_DelayTry(500);
    set_DelaySend(50);
    
    set_LogMarks(true);
    set_LogMarksInterval(40);
    
    int i;

    for(i=0;i<NUMBER_OF_CHANNELS;i++)
    {
        set_Gain(i,1);
        set_Offset(i,2048);
        set_Limit(i,2048);
        set_OutletNumber(i,i/2);
        set_Purpose(i,(i%2)?'d':'p');
    }
    for(i=0;i<NUMBER_OF_OUTLETS;i++)
    {
        set_Outlet(i,i+1);    
    }
    
//    set_Neighbor(0, "192.168.1.6");
//    set_Neighbor(1, "192.168.1.7");
//    set_Neighbor(2, "192.168.1.8");
    
    /*
    m_ServerSocket.bind(get_PortTCP());         // liga o serversocket a porta
    printf("Settings Default: fez bind na porta %d\n", get_PortTCP());
    
    for(i=0;i<get_NumNeighbors();i++){
        m_Socket[i].connect(get_Neighbor(i), get_PortTCP());   // conecta os sockets de envio aos IPs dos vizinhos
        printf("Settings Default: conectou socket com %s:%d\n", get_Neighbor(i), get_PortTCP());
    }
    */    
}

void Settings::ReadFile()
{
    int i;
    FILE *f = fopen(FILENAME,"r");
    
    if(f == NULL)
    {
        LoadDefaults();
        WriteFile();
        return;
    }
    char buf[50];
    while(fgets(buf,50,f)!= NULL)
    {
        char* p = strchr(buf,'\n');
        if(p)
        {
            if(isprint(*(p-1)) == 0) *(p-1) = '\0';
            *p = '\0';
        }
        char **line;
        int l = split(buf,"=",&line);
        if(l!=2)continue;
        if(!strcmp(line[0],"server"))
        {
            set_ServerUrl(line[1]);
        }
        if(!strcmp(line[0],"address"))
        {
            set_IpAddress(line[1]);
        }
        if(!strcmp(line[0],"netmask"))
        {
            set_Netmask(line[1]);
        }
        if(!strcmp(line[0],"gateway"))
        {
            set_Gateway(line[1]);
        }
        if(!strcmp(line[0],"dhcp"))
        {
            if(!strcmp(line[1],"false"))
                set_Dhcp(0);
            else
                set_Dhcp(1);
        }
        
        if(!strcmp(line[0],"ReadRFID"))
        {
            if(!strcmp(line[1],"false"))
                set_ReadRfid(0);
            else
                set_ReadRfid(1);
        }

        if(!strcmp(line[0],"module"))
        {
            set_ModuleNumber(atoi(line[1]));
        }

//        if(!strcmp(line[0],"FreqBase"))
//        {
//            set_FreqBase(atoi(line[1]));
//        }
//        if(!strcmp(line[0],"MaxChannels"))
//        {
//            set_MaxChannels(atoi(line[1]));
//        }
//        if(!strcmp(line[0],"MaxOutlets"))
//        {
//            set_MaxOutlets(atoi(line[1]));
//        }
//        if(!strcmp(line[0],"Samples"))
//        {
//            set_Samples(atoi(line[1]));
//        }
        if(!strcmp(line[0],"EventLimit"))
        {
            set_EventLimit(atoi(line[1]));
        }
        if(!strcmp(line[0],"MBoxLength"))
        {
            set_MBoxLength(atoi(line[1]));
        }
                      
        for(i=0;i<NUMBER_OF_CHANNELS;i++)
        {
            char x[10];
            sprintf(x,"gain%d",i);
            if(!strcmp(line[0],x))
            {
                set_Gain(i,atof(line[1]));
            }
            sprintf(x,"offset%d",i);
            if(!strcmp(line[0],x))
            {
                set_Offset(i,atoi(line[1]));
            }
            sprintf(x,"limit%d",i);
            if(!strcmp(line[0],x))
            {
                set_Limit(i,atof(line[1]));
            }
            sprintf(x,"type%d",i);
            if(!strcmp(line[0],x))
            {
                set_Purpose(i,line[1][0]);
                set_OutletNumber(i,line[1][1]-'0');
            }
        }

        for(i=0;i<NUMBER_OF_OUTLETS;i++)
        {
            char x[10];
            sprintf(x,"outlet%d",i);
            if(!strcmp(line[0],x))
            {
                set_Outlet(i,atoi(line[1]));
            }
        }
        if(!strcmp(line[0],"MaxHarmonics"))
        {
            set_MaxHarmonics(atoi(line[1]));
        }
/*        
        if(!strcmp(line[0],"NumNeighbors"))
        {
            set_NumNeighbors(atoi(line[1]));
        }                
        
        if(!strcmp(line[0],"TcpPort"))
        {
            set_PortTCP(atoi(line[1]));
            //m_ServerSocket.bind(get_PortTCP()); // liga o serversocket a porta
        }     
        
        for(i=0;i<get_NumNeighbors();i++)
        {
            char x[15];
            sprintf(x,"Neighbor%d",i);               
            //printf("Vai buscar %d -> %s\n", i, x);        
            if(!strcmp(line[0],x))
            {
               // printf("Vai usar %d -> %s\n", i, line[1]);
                set_Neighbor(i, line[1]) ;
                //m_Socket[i].connect(get_Neighbor(i), get_PortTCP());   // conecta os sockets de envio aos IPs dos vizinhos
            }
        }                
        
        if(!strcmp(line[0],"MaxTries"))
        {
            set_MaxTries(atoi(line[1]));
            //m_ServerSocket.bind(get_PortTCP()); // liga o serversocket a porta
        }  
*/        
        if(!strcmp(line[0],"DelayTry"))
        {
            set_DelayTry(atoi(line[1]));
            //m_ServerSocket.bind(get_PortTCP()); // liga o serversocket a porta
        }
        
        if(!strcmp(line[0],"DelaySend"))
        {
            set_DelaySend(atoi(line[1]));
            //m_ServerSocket.bind(get_PortTCP()); // liga o serversocket a porta
        }  
        
        if(!strcmp(line[0],"LogMarks"))
        {
            if(!strcmp(line[1],"false"))
                set_LogMarks(false);
            else
                set_LogMarks(true);
        }

        if(!strcmp(line[0],"LogMarksInterval"))
        {
            set_LogMarksInterval(atoi(line[1]));
        }
        
            //printf("Param=%s Value=%s\r\n",line[0],line[1]);
    }
    
    /*       
    m_ServerSocket.bind(get_PortTCP()); // liga o serversocket a porta              
    printf("Settings LoadFile: fez bind na porta %d\n", get_PortTCP());
    
    for(i=0;i<get_NumNeighbors();i++){
        m_Socket[i].connect(get_Neighbor(i), get_PortTCP());   // conecta os sockets de envio aos IPs dos vizinhos
        printf("Settings LoadFile: conectou socket com %s:%d\n", get_Neighbor(i), get_PortTCP());
    }
    */
    
    fclose(f);    
}


void Settings::WriteFile()
{
    FILE *f = fopen(FILENAME,"w");
    int i;
    
    if(f == NULL)
    {
        printf("Error creating settings file\r\n");
        return;
    }

    fprintf(f,"server=%s\r\n",get_ServerUrl());
    fprintf(f,"address=%s\r\n",get_IpAddress());
    fprintf(f,"netmask=%s\r\n",get_Netmask());
    fprintf(f,"gateway=%s\r\n",get_Gateway());

    if(get_Dhcp())
        fprintf(f,"dhcp=true\r\n");        
    else
        fprintf(f,"dhcp=false\r\n");

    if(get_ReadRfid())
        fprintf(f,"ReadRFID=true\r\n");        
    else
        fprintf(f,"ReadRFID=false\r\n");

    fprintf(f,"module=%d\r\n",get_ModuleNumber());
//    fprintf(f,"MaxChannels=%d\r\n",get_MaxChannels());
//    fprintf(f,"MaxOutlets=%d\r\n",get_MaxOutlets());    
//    fprintf(f,"FreqBase=%d\r\n",get_FreqBase());
//    fprintf(f,"Samples=%d\r\n",get_Samples());
    fprintf(f,"EventLimit=%d\r\n",get_EventLimit());    
    fprintf(f,"MBoxLength=%d\r\n",get_MBoxLength());    
    
    for(i=0;i<NUMBER_OF_CHANNELS;i++)
    {
        fprintf(f,"gain%d=%0.4f\r\n",i,get_Gain(i));
        fprintf(f,"offset%d=%d\r\n",i,get_Offset(i));
        fprintf(f,"limit%d=%0.4f\r\n",i,get_Limit(i));
        fprintf(f,"type%d=%c%d\r\n",i,get_Purpose(i),get_OutletNumber(i));
    }

    for(i=0;i<NUMBER_OF_OUTLETS;i++)
    {
        fprintf(f,"outlet%d=%d\r\n",i,get_Outlet(i));
    }
    fprintf(f,"MaxHarmonics=%d\r\n",get_MaxHarmonics());    
    
//    fprintf(f,"NumNeighbors=%d\r\n",get_NumNeighbors());   
//    fprintf(f,"TcpPort=%d\r\n",get_PortTCP()); 
//    for(i=0;i<get_NumNeighbors();i++)
//    {
//        fprintf(f,"Neighbor%d=%s\r\n",i,get_Neighbor(i));
//    }
//    fprintf(f,"MaxTries=%d\r\n",get_MaxTries());
    fprintf(f,"DelayTry=%d\r\n",get_DelayTry());
    fprintf(f,"DelaySend=%d\r\n",get_DelaySend());        

    if(get_LogMarks())
        fprintf(f,"LogMarks=true\r\n");        
    else
        fprintf(f,"LogMarks=false\r\n");

    fprintf(f,"LogMarksInterval=%d\r\n",get_LogMarksInterval());

        
    fclose(f);
}
            
void Settings::ShowValues()
{        
    printf("ServerUrl: %s\n", get_ServerUrl());
    printf("IpAddress: %s\n", get_IpAddress());    
    printf("NetMask: %s\n",   get_Netmask());
    printf("Gateway: %s\n",   get_Gateway());
    printf("Dhcp: %d\n",      get_Dhcp());
    printf("ReadRFID: %d\n",  get_ReadRfid());
    printf("ModuleNumber: %d\n", get_ModuleNumber() );
//    printf("FreqBase : %d\n", get_FreqBase() );
//    printf("Samples : %d\n" , get_Samples() );
//    printf("MaxChannels : %d\n", get_MaxChannels() );
//    printf("MaxOutlets  : %d\n", get_MaxOutlets() );        
    printf("EventLimit : %d\n" , get_EventLimit() );
    printf("MBoxLength : %d\n" , get_MBoxLength() );    
    printf("Per Channel\n");
    int i;
    for(i=0;i<NUMBER_OF_CHANNELS;i++)
    {
        printf("Channel %d Gain %f Offset %d Limmit %f Outlet %d Purpose %c\n ", i, get_Gain(i), get_Offset(i), get_Limit(i), get_OutletNumber(i), get_Purpose(i));
    }
    printf("Per Outlet \n");
    for(i=0;i<NUMBER_OF_OUTLETS;i++)
    {
        printf("Outlet %d Number %d \n ", i, get_Outlet(i));
    }
    printf("MaxHarmonics : %d\n", get_MaxHarmonics() );
    
//    printf("NumNeighbors : %d\n", get_NumNeighbors() );
//    for(i=0;i<get_NumNeighbors();i++)
//    {
//        printf("Neighbor %d Value %s \n ", i, get_Neighbor(i));
//    }
//    printf("TcpPort : %d\n", get_PortTCP() );
//    printf("MaxTries : %d\n", get_MaxTries() );

    printf("DelayTry : %d\n", get_DelayTry() );
    printf("DelaySend : %d\n", get_DelaySend() );
}