#include <mbed.h>
#include <EthernetInterface.h>

#include "Definitions.h"
#include "calculos.c"

EthernetInterface eth;
TCPSocketConnection socket;

LocalFileSystem local("local");
AnalogIn captura(p20);
DigitalOut myled(LED1);

void IniciaEthernet(void);
int gravaAmostras(float *vet, int amostras);
int gravaDFT(float *seno, float *coss, int amostras);
int sendMessage(float *vet, int amostras);
    
int main() {
    float vet[AMOSTRAS];
    //float controle[AMOSTRAS];
    //float seno[AMOSTRAS];
    //float coss[AMOSTRAS];
    float vm;
    int i, flag =0;
    Timer t;
    unsigned short int valor, maior=0, menor=0;
    float espera,rms;
    float media = 0;
    
    IniciaEthernet();
    
    printf("CONVERSAOAD %1.10f\n", CONVERSAOAD);
    printf("PORTA       p16 Diferencial 1\n");
    printf("Ciclos (HZ) %d\n", CICLO);
    printf("Amostras    %d\n", AMOSTRAS);
    printf("Intervalo   %1.10f\n", INTERVALO);
        
    for(int j =0; j < 5000; j++){
        t.start();    
        for(i=0; i < AMOSTRAS; i++){
            //controle[i] = t.read();
            valor = captura.read_u16();
            vet[i] = (float) valor;//(float) (valor - 33575) / 10830;        //acquire the value and convert the analog to digital

            if(i == 0)
                maior = menor = vet[i];
            if (valor > vet[i])
                maior = vet[i];
            if (valor < vet[i])
                menor = vet[i];
            media += vet[i];
 
            espera = (INTERVALO * (i+1)) - t.read();
            wait(espera);
        }
        rms = RMS(vet, AMOSTRAS);
        printf("Acabou captura. Tempo %1.10f RMS %1.19f\n", t.read(), rms );
        
        for(i=0; i < AMOSTRAS; i++)
            printf("%.0f*", vet[i]);
        printf("\n");
        //printf("Tempo de Captura %1.10f\n", t.read());      
        /*
        media=0;
        for(i=0; i < AMOSTRAS; i++){
            if(i == 0)
                maior = menor = valor;
            if (vet[i] > maior)
                maior = (unsigned short int) vet[i];
            if (vet[i] < menor)
                menor = (unsigned short int) vet[i];
            media += vet[i];
        }
        */
        //t.reset();
        //vm = DFT(vet, seno, coss);
        //CalculateFFT(vet, seno, coss, &vm, 1, 0);
        //gravaDFT(seno, coss, AMOSTRAS);
        //printf("Calculou DFT em %fs\n", t.read());
        
        /*
        media /= AMOSTRAS;
        printf("[%d] Calculado RMS %1.10f VM %1.10f\n", j, rms, media);                                    
        
        if (rms > LIMITE){
            flag++;
            /*
            if (flag > 1){
                sendMessage(vet, AMOSTRAS);
                printf("Calculado RMS Enviado %f\n", rms);                                    
                break;
            }
            
        }
        */
        //printf("[%d] RMS %1.8f Menor %d Maior %d Media %1.8f VM %1.8f\n", j, RMS(vet, AMOSTRAS), menor, maior, vm, (float) media/AMOSTRAS);
        
        //wait(5);
    /*    
        for(i=0; i < AMOSTRAS; i++){
            printf("[%d] Valor %f\tTempo %1.10f\n", i, vet[i], controle[i]);
        }
       float maior =-10;   
       float media = 0;
       for(i=2; i < AMOSTRAS; i++){
            espera = (controle[i] - controle[i-1] - INTERVALO);
            media += espera;
            if (espera > 0.000001){
                //printf("[%d] Diferenca %f\n", i, espera);
                if (espera > maior)
                    maior = espera;
            }
        }
        printf("[%d] MAior difrenca %1.10f Media %1.10f\n", j, maior, (float) media/AMOSTRAS);
        */
    }            
    printf("FINAL");
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}


void IniciaEthernet(void){
    eth.init("192.168.103.2","255.255.255.0","192.168.0.1");
        
    //EthernetIf::Connect();
    eth.connect();
    //printf("IP Address is %s\n", EthernetIf::get_IpAddress());
    printf("IP Address is %s\n", eth.getIPAddress());
        
}


int sendMessage(float *vet, int amostras){
    int i, ret;
    float num;
    
    char *msg;
    char aux[9];
    
    TCPSocketConnection sock;
    sock.connect("192.168.103.1", 12345);
    //printf("Nova Malloc4\n");
    msg = (char *)malloc((amostras/2*9*sizeof(char)) + 1);
    if (msg == NULL){
        printf("Sem memoria\n");
    }
    msg[0] = '\0';
    printf("\n\n\nprimeira parte\n");
    for(i=0; i<amostras/2; i++){
        num = vet[i];        
        sprintf(aux, "%08X;", *(unsigned int*)&num )  ;
        if (i == 0 || i == 100 || i == 500 || i == 1023)
            printf("%d\t%s\n", i, aux);

        strcat(msg, aux);
    }    
    ret = sock.send(msg, strlen(msg)) ;
    
    if (ret != -1){
        msg[0] = '\0';
        printf("\n\n\nsegunda parte\n");
        for(i=amostras/2; i<amostras; i++){
            num = vet[i];        
            sprintf(aux, "%08X;", *(unsigned int*)&num )  ;
            if (i == 1024 || i == 1124 || i == 1524 || i == 2047)
                printf("%d\t%s\n", i, aux); 
            strcat(msg, aux);
        }    
        ret = sock.send(msg, strlen(msg)) ;
        //printf("[%s]\n", msg);
        //sock.close();
    } 
     
    if (ret != -1)
        return (1);
    
    return (0);
}


int gravaDFT(float *seno, float *coss, int amostras){
    int i;
    FILE *f = fopen("/local/resultados.txt","w");    
    
    if(f == NULL)
    {
        printf("Error creating file resultados.txt\r\n");
        return 0;
    }
    
    fprintf(f, "Arquivo de Resultados\n");
    for(i=0; i < amostras; i++){        
        fprintf(f,"%1.4f\t%1.4f\n", seno[i], coss[i]);
    }
    fprintf(f,"\r\n");
    fclose(f);
    return (1);
 }


int gravaAmostras(float *vet, int amostras){
    int i;
    FILE *f = fopen("/local/amostras.txt","w");    
    
    if(f == NULL)
    {
        printf("Error creating file amostras.txt\r\n");
        return 0;
    }
    
    fprintf(f, "Arquivo de Amostras\n");
    for(i=0; i < amostras; i++){        
        fprintf(f,"%1.4f\n", vet[i]);
        printf("%1.4f*", vet[i]);
    }
    fprintf(f,"\r\n");
    fclose(f);
    return (1);
 }



