/* 
    Novo projeto MBED_Limpo
    Criado para: Tentar reduzir o consumo de memória.
    - Tirei do Seetings
        - m_MaxChannels    --> tem constante (NUMBER_OF_CHANNELS). Se mudar tem de recompilar
        - m_MaxOutlets     --> tem constante (NUMBER_OF_OUTLETS). Se mudar tem de recompilar
        - m_Samples        --> tem constante (NUMBER_OF_SAMPLES). Se mudar tem de recompilar
        - m_FreqBase       --> Adicionei constante (FREQBASE). Se mudar tem de recompilar.
        - m_NumNeighbors   --> Não utilizado, sem acompanhamento    
        - m_Neighbor[]     --> Não Utilizado, sem acompanhamento    
        - m_PortTCP        --> Não Utilizado, sem acompanhamento    
        - m_ServerSocket   --> Não Utilizado, sem acompanhamento    
        - m_Socket[]       --> Não Utilizado, sem acompanhamento
        - m_MaxTries       --> Adicionei constante (MAXTRIES). Se mudar tem de recompilar.
*/


#define MSGWINDOW "Limpo - Version 5"

#include <stdio.h>

#include "mbed.h"
#include "rtos.h"
#include "cmsis_os.h"
//#include "EthernetIf.h"
#include "EthernetInterface.h"
#include "Settings.h"
#include "Capture.h"
#include "Http_post.h"
//#include "CommTCP.h"
#include "SignalProcessor.h"
#include "EventDetector.h"
#include "limites.h"

#include "TelnetServer.h"

#include "tftpsrv.h"
#include "ntpc.h"

#include "PmedLog.h"

#include "NTPClient.h"

#include "whatchdog.h"

//__attribute((section("AHBSRAM0"),aligned)) char LargeBuffer[1024]; 
EthernetInterface eth;
Watchdog wdt;

void InitializeEthernetLink()
{
    if(Settings::get_Dhcp())
        //EthernetIf::Initialize(); //Use DHCP
        eth.init(); //Use DHCP
    else
        //EthernetIf::Initialize(Settings::get_IpAddress(),Settings::get_Netmask(),Settings::get_Gateway());
        eth.init(Settings::get_IpAddress(),Settings::get_Netmask(),Settings::get_Gateway());
        
    //EthernetIf::Connect();
    eth.connect();
    //printf("IP Address is %s\n", EthernetIf::get_IpAddress());
    printf("IP Address is NEW %s\n", eth.getIPAddress());
}

int main() {
    DigitalOut myled3(LED3); //The pushbutton or power on caused a reset
    DigitalOut myled4(LED4); //The watchdog timer caused a reset
    
    if ((LPC_WDT->WDMOD >> 2) & 1){
        myled4 = 1; 
        PmedLog::WriteEntry(PMEDLOG_INITIALIZINGWDT);
    }
    else{        
        myled3 = 1;
        PmedLog::WriteEntry(PMEDLOG_INITIALIZING);
    }

    printf("\r\n %s \r\n", MSGWINDOW);
    FILE *f;
    
    //Set Highest Priority
    //osThreadSetPriority(osThreadGetId(),osPriorityHigh);
    
    Settings::ReadFile();    
    //printf("Passou Settings, carregou arquivo\n");
    //Settings::ShowValues();
    
    InitializeEthernetLink();
    printf("Inicializou link Ethernet\n");
    
    //Start HTTP POST service
    Thread http_post(HttpPost::HttpPost_Thread);            
    
    //Start TCP daemon service
    //Thread TcpService(CommTCP::CommTCP_Thread);
        
    //Start Telnet Service
    Thread telnetserver(TelnetServer::TelnetServer_Thread);    
    
    //Start TFTP Service    
    Thread tftpsrv(tftpsrv::tftpsrv_Thread);
    
    //Start NTP Client for refresh time
    //Thread ntpc(ntpc::ntpc_Thread);
    time_t tempo = time(NULL);
    if ((tempo+60) < 1420077600) set_time(1420077600);
    
   // ntpClient.setTime("192.168.103.101");
    
    DisplayRAMBanks();
    
    /*
    unsigned short vet[256] = {2105,2105,2113,2127,2127,2125,2112,2113,2130,2130,2123,2112,2112,2128,2128,2123,2112,2113,2136,2136,2374,2551,2671,2869,2887,3036,2964,2964,2964,3145,3145,3206,3209,3298,3298,3264,3261,3208,3239,3239,3197,3197,3113,3032,3065,3065,3000,2901,2943,2943,2900,2852,2844,2863,2863,2838,2764,2791,2724,2724,2668,2710,2636,2658,2658,2606,2527,2443,2434,2434,2258,2066,2061,2080,2080,2063,2055,2055,2070,2070,2064,2051,2054,2069,2069,2062,2054,2058,2066,2309,2062,2052,2054,2067,2067,2063,2051,2049,2068,2068,2060,2053,2050,2067,2066,2069,2051,2053,2070,2070,2064,2050,2053,2070,2070,2062,2052,2055,2068,2068,2065,2052,2057,2072,2072,2064,2054,2054,2072,2072,2064,2053,2052,2069,2069,2064,2052,2053,2064,2064,2062,2049,2051,2067,2067,2059,2051,2050,2068,2068,2058,2046,2050,2068,2068,2061,2052,2058,2068,2068,2059,2052,2053,2067,2067,1744,1526,1471,1289,1289,1137,1142,1055,1120,1120,997,967,894,941,941,928,887,1001,949,949,1028,1105,1079,1191,1191,1223,1211,1223,1267,1267,1325,1267,1356,1327,1327,1369,1439,1381,1498,1498,1503,1503,1527,1545,1545,1635,1650,1778,1792,1792,1971,2108,2109,2126,2126,2124,2117,2118,2131,2131,2126,2118,2118,2138,2138,2134,2124,2114,2135,2135,2129,2121,2120,2136,2136,2128,2122,2122,2143,2120,2130,2120,2121,2139,2139,2130,2119,2121,2136,2136,2129};
    float sen[12],cos[12],vm;
    SignalProcessor::CalculateFFT(vet,sen,cos,&vm,1);
    
    printf("VM = %f\n",vm);
    for(int i=0;i<12;i++)
    {
        printf("SEN%d = %f, COS%d = %f\n",i,sen[i],i,cos[i]);
    }
    */
    printf(PMEDLOG_INITIALIZINGWDT);
    printf("\n\n");
    
    //printf("0x%lx\n",  LargeBuffer);
    
    PmedLog::WriteEntry(PMEDLOG_STARTED);
    
    /* Teste com WhatchDog
    //Jump to the capture routine(will run on this thread)  
    thread1(NULL);
    */
    
    /* start test WahtchDog */
    DigitalOut led1(LED1);
    int n = 0;
    float rms[NUMBER_OF_CHANNELS], mv2[NUMBER_OF_CHANNELS];
    int under[NUMBER_OF_CHANNELS], over[NUMBER_OF_CHANNELS];
    
    wdt.kick(10.0);  
    
    Capture::InitializeAD();
       
    while(1)
    {
        //get sample values from 6 channels
        Capture::AcquireValues();
        
        // Calcula o RMS dos 6 canais
        SignalProcessor::CalculateRMSBulk(rms, mv2, under, over);
                
        for(int i=0;i<6;i++){
            EventDetector::get_Detector(i).ProcessEvent(rms[i], mv2[i], under[i], over[i]);
        }

        n++;
        if(n==60)
        {
            printf("%.2f %.0f %.2f %.0f\t%.2f %.0f %.2f %.0f\t%.2f %.0f %.2f %.0f\n",rms[0], mv2[0],rms[1],mv2[1],rms[2],mv2[2],rms[3],mv2[3],rms[4],mv2[4],rms[5],mv2[5]);
            led1 = !led1;            
            n=0;    
            
            PmedLog::Mark();            
        }
        
        // End of main loop so "kick" to reset watchdog timer and avoid a reset
        wdt.kick();
        
    }    
    /* end test WahtchDog */
    
    while(1){//never reaches here  
        PmedLog::WriteEntry(PMEDLOG_WRONGCODE);
        printf("Reset\n");
        f = fopen(FILENAMERESET, "a");
        if (f == NULL)            
            f = fopen(FILENAMERESET, "w");
        fprintf(f, "Laco Errado\n");
        fclose(f);
        Thread::yield();
    }
}

