/*
 * Settings.h
 *
 *  Created on: 19/jan/2015
 *      Author: Marcos A. Lucas
 */
 
#ifndef PMEDRESET_H
#define PMEDRESET_H

#include "mbed.h"
#include "Settings.h"

#include "PmedLog.h"

extern "C" void mbed_reset();

static void Pmed_reset();
static void Pmed_reset(const char* value);


static void Pmed_reset()
{
    Pmed_reset(PMEDLOG_RESET);
}

static void Pmed_reset(const char* value)
{
    char entry[80];
    
    entry[0] = '\0';
    strcat(entry, "RESET : ");
    strcat(entry, value);
    PmedLog::WriteEntry(entry);
    wait(1);
    mbed_reset();
}

#endif //#ifndef PMEDRESET_H

