/*
 * dma.c
 *
 *  Created on: 03/07/2011
 *      Author: francisco
 */
#include <LPC17xx.h>
#include "dma.h"

#define LPC_GPDMACH          ((LPC_GPDMACH_TypeDef   **) LPC_GPDMACH0_BASE )

void init_dma()
{
    LPC_SC->PCONP |= 1<<29;     //Power GPDMA module

    LPC_GPDMA->DMACConfig = 1;  //Enable GPDMA

    //Clear any previous interrupts
    LPC_GPDMA->DMACIntTCClear = 0xFF;
    LPC_GPDMA->DMACIntErrClr = 0xFF;

    NVIC_SetPriority(DMA_IRQn,(1<<__NVIC_PRIO_BITS) - 1);
    NVIC_EnableIRQ(DMA_IRQn);
}

void setup_channel(dmaLinkedListNode* pList,int ch,int src,int dst)
{
    //Initialize the channel with previously configured LL;
    LPC_GPDMACH0->DMACCSrcAddr = pList->sourceAddr;
    LPC_GPDMACH0->DMACCDestAddr = pList->destAddr;
    LPC_GPDMACH0->DMACCControl = pList->dmaControl;
    LPC_GPDMACH0->DMACCLLI = (unsigned long int) pList & 0xFFFFFFFC; //Lower bits must be 0

    int transfer_type;
    if(src == DMA_MEMORY && dst != DMA_MEMORY)
    {
        transfer_type = DMA_MEMORY_TO_PERIPHERAL;
        src = 0;
    }
    else if(src != DMA_MEMORY && dst == DMA_MEMORY)
    {
        transfer_type = DMA_PERIPHERAL_TO_MEMORY;
        dst = 0;
    }
    else if(src == DMA_MEMORY && dst == DMA_MEMORY)
    {
        transfer_type = DMA_MEMORY_TO_MEMORY;
        src=dst = 0;
    }
    else if(src != DMA_MEMORY && dst != DMA_MEMORY)
        transfer_type = DMA_PERIPHERAL_TO_PERIPHERAL;

    //Set up all relevant bits
    LPC_GPDMACH0->DMACCConfig = (src<<1) | (dst<<5) | (transfer_type<<11) | (1<<15);

    //Finally, enable the channel -
    LPC_GPDMACH0->DMACCConfig |= 1<<0;
}

void stop_channel()
{
    LPC_GPDMACH0->DMACCConfig &= ~(1<<0);
}
