/*
 * dma.h
 *
 *  Created on: 03/07/2011
 *      Author: francisco
 */
 #ifndef DMA_H
 #define DMA_H

#define DMA_MEMORY                  -1

#define DMA_PERIPHERAL_SSP0_TX      0U
#define DMA_PERIPHERAL_SSP0_RX      1U
#define DMA_PERIPHERAL_SSP1_TX      2U
#define DMA_PERIPHERAL_SSP1_RX      3U
#define DMA_PERIPHERAL_ADC          4U
#define DMA_PERIPHERAL_I2S0         5U
#define DMA_PERIPHERAL_I2S1         6U
#define DMA_PERIPHERAL_DAC          7U
#define DMA_PERIPHERAL_UART0_TX     8U
#define DMA_PERIPHERAL_UART0_RX     9U
#define DMA_PERIPHERAL_UART1_TX     10U
#define DMA_PERIPHERAL_UART1_RX     11U
#define DMA_PERIPHERAL_UART2_TX     12U
#define DMA_PERIPHERAL_UART2_RX     13U
#define DMA_PERIPHERAL_UART3_TX     14U
#define DMA_PERIPHERAL_UART3_RX     15U

#define DMA_MEMORY_TO_MEMORY            0U
#define DMA_MEMORY_TO_PERIPHERAL        1U
#define DMA_PERIPHERAL_TO_MEMORY        2U
#define DMA_PERIPHERAL_TO_PERIPHERAL    3U

#define DMA_DEST_SIZE(n)            (n<<15)
#define DMA_SRC_SIZE(n)             (n<<12)

#define DMA_SRC_WIDTH_BYTE          (0U<<18)
#define DMA_SRC_WIDTH_HALFWORD      (1U<<18)
#define DMA_SRC_WIDTH_WORD          (2U<<18)

#define DMA_DST_WIDTH_BYTE          (0U<<21)
#define DMA_DST_WIDTH_HALFWORD      (1U<<21)
#define DMA_DST_WIDTH_WORD          (2U<<21)

#define DMA_SRC_INCREMENT           (1U<<26)
#define DMA_DST_INCREMENT           (1U<<27)

#define DMA_TC_INT                  (1U<<31)

#ifdef __cplusplus
extern "C" {
#endif

typedef struct
{
    unsigned long int sourceAddr;
    unsigned long int destAddr;
    unsigned long int nextNode;
    unsigned long int dmaControl;
} dmaLinkedListNode;

extern void init_dma(void);
extern void setup_channel(dmaLinkedListNode* pList,int ch,int src,int dst);
extern void stop_channel(void);

#ifdef __cplusplus
}
#endif

#endif //#define DMA_H
