#include "mbed.h"
#include "EthernetInterface.h"
#include "string.h"
#include "stdio.h"

#include "Configuracoes.h" 
#include "CommTCP.h"
#include "Http_post.h"

void InitializeEthernetLink();
void *montamsg(char *msg, int seq, char *type);
void SendMessage(char *msg);

EthernetInterface eth;
int errorCnt = 0;
int errorSnd = 0;

DigitalOut myled(LED1);

int main() {
    char msg[50];
    int c=0;
    
    InitializeEthernetLink();
    printf("Test %s with2 %d messages\n", MSG, FINAL);
    
    //Start TCP daemon service
    Thread TcpService(CommTCP::CommTCP_Thread);

    //wait(2); //Time to TCP bind and listen
    while(1) {       
        
        if (PING){
            montamsg(msg, c++, "Ping");
            SendMessage(msg);
        }
        else{
            montamsg(msg, c++, "Pong");
            SendMessage(msg);
        }
        //printf("%s\n", msg);
                
        TCPSocketConnection s;
        HttpPost::DoPost(s, APACHE);                       
        
        if(c % 1000 == 0){
            printf("%s\n", msg);
            //wait(10);
        }
                
        if (c == FINAL) {
            printf("Vai acabar |||\n");
            //while(CommTCP::getCont() < FINAL);
            //wait(3);
            break;
        }
    }
    printf("Foram recebidas %d mensagens corretas\n", CommTCP::getCont() );
    printf("%d Erros of connection and %d Errors of send\n", errorCnt, errorSnd);
    printf("%d Erros of HTTP connection and %d Errors of send\n", HttpPost::getCountCnt(), HttpPost::getCountSnd() );
    printf("%d Erros of TCP connection and %d Errors of send\n", CommTCP::getCountCnt(), CommTCP::getCountSnd() );
    //TcpService.terminate();
    
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

void SendMessage(char *msg){
    TCPSocketConnection socket;
    int r, i;
    
    
    for(i = 0; i < MAXTRIES; i++){
        r = socket.connect(VIZINHO, TCPPORT);
        if (r < 0) {
            if (i == 0)
                errorCnt++;
            printf("Error %d Unable to connect %d to (%s) on port (%d) Try %d\n", errorCnt, r, VIZINHO, TCPPORT, i);
            wait_ms(DELAYTRY);
        }
        else
            break;
    }
    if (r == 0) {
        for(i =0; i < MAXTRIES; i++){
            r = socket.send_all(msg, strlen(msg));        
            if (r < 0) {
                if (i == 0)
                    errorSnd++;
                printf("Error %d Unable to Send Try %d\n", errorSnd, i);
                wait_ms(DELAYTRY);
            }
            else
                break;
        }
        wait_ms(DELAY);
        //printf("Enviou Mensagem %s com %d bytes\n", msg, strlen(msg));
        socket.close();
    }
    
    return;
}


void *montamsg(char *msg, int seq, char *type){
    char aux[10];
    
    memset(msg, 0, sizeof(msg));
    strcat(msg, MEUIP);
    strcat(msg, ":");
    strcat(msg, type);
    strcat(msg, ":");
    sprintf(aux, "%d", seq);
    strcat(msg, aux);
    
    return NULL;
}

void InitializeEthernetLink()
{
    eth.init(MEUIP,"255.255.255.0","192.168.1.5");
        
    eth.connect();
    printf("IP Address is %s\n", eth.getIPAddress());
}