#ifndef ETHERNETIF_H
#define ETHERNETIF_H

#if !defined(TARGET_LPC1768)
#error The Ethernet Interface library is supported only on the mbed NXP LPC1768
#endif

#include "rtos.h"
#include "lwip/netif.h"


class EthernetIf
{
    static struct netif lpcNetif;
    static bool use_dhcp;
    
    static ip_addr_t ip_n,netmask_n,gw_n;
    
    static Semaphore tcpip_initialized;
    static void tcpip_init_done(void *arg);
    static void link_status_callback(struct netif *netif);
    static void interface_status_callback(struct netif *netif);
    
    static Semaphore link_up;
    static Semaphore netif_up;
    
    static bool link_is_up;
    
    static uint32_t os_timer_cb_led[5]; 
    static osTimerDef_t os_timer_def_led;

    static int _init();
    static void led_refresh(void const* arg);
public:
    static int Initialize();
    static int Initialize(char *ip,char *netmask,char *gw);
    
    static int Connect(unsigned int timeout = 15000);
    static int Disconnect();
    
    static char* get_IpAddress();
    static char* get_Netmask();
    static char* get_Gateway();
    static bool is_LinkUp();
    static bool is_InterfaceUp();
    
    
};

#include "TCPSocketConnection.h"
#include "TCPSocketServer.h"

#include "Endpoint.h"
#include "UDPSocket.h"

#endif //#ifndef ETHERNETIF_H
