#include "TelnetServer.h"

#include "Settings.h"

 char *wrong_args_msg_get = "Wrong number of arguments.\r\n\r\nUsage: getparam <parameter name>\r\n";
 char *param_not_found_msg_get = "Parameter not found.\r\n\r\n";


int TelnetServer::GetParamCommand(TCPSocketConnection *conn,char** argv,int argc)
{

    if(argc != 2)
    {
        conn->send(wrong_args_msg_get,strlen(wrong_args_msg_get));
        return 0;
    }

    printf("Getting parameter\n");

    if(!strcmp(argv[1],"ipserver"))
    {
        conn->send("\r\nipserver=",strlen("\r\nipserver="));
        conn->send(Settings::get_ServerUrl(),strlen(Settings::get_ServerUrl()));
        conn->send("\r\n",strlen("\r\n"));
        return 0;
    }

    if(!strcmp(argv[1],"module"))
    {
        char b[12];
        conn->send("\r\nmodule=",strlen("\r\nmodule="));
        sprintf(b,"%d\r\n",Settings::get_ModuleNumber());
        conn->send(b,strlen(b));
        return 0;
    }

    int i;
    for(i=0;i<Settings::get_MaxOutlets();i++)
    {
        char b[12];
        sprintf(b,"outlet%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\noutlet%d=%d\r\n",i,Settings::get_Outlet(i));
            conn->send(b,strlen(b));
            return 0;
        }
    }
    for(i=0;i<Settings::get_MaxChannels();i++)
    {
        char b[12];
        sprintf(b,"gain%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\ngain%d=%f\r\n",i,Settings::get_Gain(i));
            printf("Getting gain\n");
            conn->send(b,strlen(b));
            return 0;
        }

        sprintf(b,"offset%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\noffset%d=%d\r\n",i,Settings::get_Offset(i));
            conn->send(b,strlen(b));
            return 0;
        }

        sprintf(b,"limit%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\nlimit%d=%f\r\n",i,Settings::get_Limit(i));
            conn->send(b,strlen(b));
            return 0;
        }

        sprintf(b,"outlet_number%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\noutlet_number%d=%d\r\n",i,Settings::get_OutletNumber(i));
            conn->send(b,strlen(b));
            return 0;
        }

        sprintf(b,"purpose%d",i);
        if(!strcmp(argv[1],b))
        {
            sprintf(b,"\r\npurpose%d=%c\r\n",i,Settings::get_Purpose(i));
            conn->send(b,strlen(b));
            return 0;
        }
    }

    conn->send(param_not_found_msg_get,strlen(param_not_found_msg_get));
    return 0;

}
