/*
 * EventDetector.h
 *
 *  Created on: 
 *      Author: 
 */
 
#ifndef EVENTDETECTOR_H
#define EVENTDETECTOR_H

#include <stdlib.h>

#include "rtos.h"

#include "Settings.h"
#include "Capture.h"
#include "SignalProcessor.h"

class CaptureEvent
{
    char m_RFID[9];
    int m_Type;
    int m_OutletNumber;
    float m_MeanValue;
    float m_RMSValue;
    float m_Gain;
    int m_Offset;
    float m_Sin[NUMBER_OF_HARMONICS];
    float m_Cos[NUMBER_OF_HARMONICS];
    
public:
    
    CaptureEvent();
    
    void Setup(char* rfid,int type,int outlet,float mv,float rms,float gain, int offset,float* sin, float* cos);    
        
    char* get_RFID() { return m_RFID; }
    int get_Type() { return m_Type; }
    int get_OutletNumber() { return m_OutletNumber; }
    float get_MeanValue() { return m_MeanValue; }
    float get_RMSValue() { return m_RMSValue; }
    float get_Gain() { return m_Gain; }
    int get_Offset() { return m_Offset; }
    float get_SineValue(int idx) { return m_Sin[idx]; }
    float get_CossineValue(int idx) { return m_Cos[idx]; }
};

typedef Mail<CaptureEvent,LENGTH_MAIL_BOX> CaptureMailbox;

class EventDetector
{
protected:

    static CaptureMailbox m_EventMailbox;
    static const int m_EventLimit;
    
    static EventDetector m_Detector[NUMBER_OF_CHANNELS];

    bool m_OutletTriggered;
    int m_EventCounter;
    int m_Channel;

    void OnTrigger(float rmsvalue);
    
    void SendMessage(int ext,float rmsvalue);
    
    int TimeDelay(int t);
        
public:

    EventDetector(int ch);
    
    void ExternalTrigger();
    
    void ProcessEvent(float rmsvalue, int t);
    
    void ShowValues(CaptureEvent* e);
    
    static CaptureMailbox& GetMailbox() { return m_EventMailbox; }
    static EventDetector& get_Detector(int ch) { return m_Detector[ch]; }
    
};

#endif