#include "TelnetServer.h"


char *header_msg = "firmware update\r\n\r\n";
char *usage_msg = "Wrong arguments\r\nUsage: update <firmware filename>\r\n\r\n";
char *invalid_filename_msg = "Invalid filename. It must have at most 8 characters in the name and 3 in the extension\r\n\r\n";
char *file_does_not_exist_msg = "A file with the supplied filename does not exist.\r\n\r\n";
char *version_does_not_exist_msg = "Could not open version.txt. The update operation cannot continue.\r\n\r\n";
char *unable_to_create_remove_msg = "Unable to create remove.txt. The update operation cannot continue.\r\n\r\n";
char *unable_to_truncate_version_msg = "Unable to truncate version.txt. The update operation cannot continue.\r\n\r\n";
char *operation_successful_msg = "Operation was completed successfully. Now resetting...\r\n\r\n";

extern LocalFileSystem local;
extern "C" void mbed_reset();

int TelnetServer::UpdateCommand(TCPSocketConnection *conn,char** argv,int argc)
{
    char old_filename[20];
    char new_filename[20];

    conn->send(header_msg,strlen(header_msg));
    //0 - check if the file informed exists
    if(argc != 2)
    {
        conn->send(usage_msg,strlen(usage_msg));
        return 0;
    }

    strcpy(new_filename,"/local/");
    strcat(new_filename,argv[1]);
    new_filename[19] = '\0';
    printf("New filename = %s\n",new_filename);

    if(strlen(new_filename) > 19)
    {
        conn->send(invalid_filename_msg,strlen(invalid_filename_msg));
        return 0;
    }

    FILE* fn = fopen(new_filename,"r");
    if(fn == NULL)
    {
        conn->send(file_does_not_exist_msg,strlen(file_does_not_exist_msg));
        return 0;
    }
    fclose(fn);

    //1 - write remove.txt with the current FW filename
    fn = fopen("/local/version.txt","r");
    if(fn == NULL)
    {
        conn->send(version_does_not_exist_msg,strlen(version_does_not_exist_msg));
        return 0;
    }
    int rd = fread(old_filename,1,19,fn);
    old_filename[rd]='\0';
    fclose(fn); 

    fn = fopen("/local/remove.txt","w");
    if(fn == NULL)
    {
        conn->send(unable_to_create_remove_msg,strlen(unable_to_create_remove_msg));
        return 0;
    }
    fwrite(old_filename,1,strlen(old_filename),fn);
    fclose(fn);

    //2 - write version.txt with the new FW filename
    fn = fopen("/local/version.txt","w");
    if(fn == NULL)
    {
        conn->send(unable_to_truncate_version_msg,strlen(unable_to_truncate_version_msg));
        return 0;
    }
    fwrite(new_filename,1,strlen(new_filename),fn);
    fclose(fn);

    //3 - remove the old fw file
    local.remove(old_filename);

    //4 - remove remove.txt
    local.remove("remove.txt");

    conn->send(operation_successful_msg,strlen(operation_successful_msg));

    //5 - reset    
    delete conn;

    mbed_reset();

    return 0;
}
