#include "TelnetServer.h"

char *header_msg_remove = "File removed successfully\r\n\r\n";
char *wrong_args_msg_remove = "Wrong number of arguments.\r\n\r\nUsage: remove <filename>\r\n";
char *file_not_found_msg_remove = "File not found.\r\n\r\n";

extern LocalFileSystem local;

int TelnetServer::RemoveCommand(TCPSocketConnection *conn,char** argv,int argc)
{

    if(argc != 2)
    {
        conn->send(wrong_args_msg_remove,strlen(wrong_args_msg_remove));
        return 0;
    }

    char fullpath[256];
    strcpy(fullpath,"/local/");
    strcat(fullpath,argv[1]);
    printf("File = %s\n",fullpath);  
    FILE* f = fopen(fullpath,"r");
    if(f == NULL)
    {
        conn->send(file_not_found_msg_remove,strlen(file_not_found_msg_remove));
        return 0;
    }

    fclose(f);

    local.remove(argv[1]);

    conn->send(header_msg_remove,strlen(header_msg_remove));

    return 0;
}