#include "mbed.h"
#include "rtos.h"

#include "EthernetInterface.h"

typedef int(*cmd_function)(TCPSocketConnection *conn,char**,int);

struct telnet_cmd_handler {
    char* command_name;
    cmd_function pfn;
};


class TelnetServer
{
    static const struct telnet_cmd_handler cmds[];
    
public:
    static void TelnetServer_Thread(void const* arg);    
    static void TelnetSession(TCPSocketConnection *conn);    
    static void option_negotiator(TCPSocketConnection *conn,unsigned char opt_cmd,unsigned char opt_param);    
    static int HelpCommand(TCPSocketConnection     *conn,char** argv,int argc);
    static int ListParamCommand(TCPSocketConnection *conn,char** argv,int argc);
    static int GetParamCommand(TCPSocketConnection *conn,char** argv,int argc);
    static int SetParamCommand(TCPSocketConnection *conn,char** argv,int argc);
    static int ResetCommand(TCPSocketConnection    *conn,char** argv,int argc);
    static int RemoveCommand(TCPSocketConnection   *conn,char** argv,int argc);
    static int VersionCommand(TCPSocketConnection  *conn,char** argv,int argc);
    static int UpdateCommand(TCPSocketConnection   *conn,char** argv,int argc);    
    
};
