/*
 * capture.h
 *
 *  Created on: 
 *      Author: 
 */

#ifndef CAPTURE_H
#define CAPTURE_H

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "mbed.h"
#include "rtos.h"
#include "dma.h"
#include "adc.h"

#include "Settings.h"

// MTR: Estes defines nao deveriam estar no arquivo de configuraçeos?
//#define SAMPLE_RATE         256U

class Capture
{
protected:

    static Semaphore m_CaptureSemaphore; //used to alert the capture thread about a ready capture 
    static int m_BufferIndex;
    
    static dmaLinkedListNode m_Nodes[2]; //this list holds the buffer configuration for the DMA peripheral
public:
    static unsigned short int m_AdcBuffers[2][NUMBER_OF_SAMPLES][NUMBER_OF_CHANNELS];

public:

    static unsigned short int GetValue(int nsamples, int nchannel);
    static void CopyBuffer(int channel, unsigned short int *dest);

    static void ISRHandler();

    static void Initialize();
    static void Start();
    static void Stop();
    static void Wait();

};

#endif