/*
 * EventDetector.cpp
 *
 *  Created on: 
 *      Author: 
 */
 
 #include "EventDetector.h"
 #include "CommTCP.h"
 
 #define MARCA 10
 #define UMCICLO 16.666666667

CaptureMailbox EventDetector::m_EventMailbox;
EventDetector EventDetector::m_Detector[NUMBER_OF_CHANNELS] = {0,1,2,3,4,5};
static int cont=0;
static int contliga=0;
static int contdesl=0;

CaptureEvent::CaptureEvent()
{
}

//void CaptureEvent::Setup(char* rfid,int type,int outlet,float mv,float rms,float gain, int offset,float* sin, float* cos)
void CaptureEvent::Setup(char* rfid, int type, int outlet, float mv, float mv2, float rms, int under, int over, float gain, int offset, int duration, float* sin, float* cos)
{
    memcpy(m_RFID,rfid,9);
    m_Type         = type;
    m_OutletNumber = outlet;
    m_MeanValue    = mv;
    m_MV2          = mv2;
    m_RMSValue     = rms;
    m_Under        = under;
    m_Over         = over;
    m_Gain         = gain;
    m_Offset       = offset;
    m_Duration     = duration;
    memcpy(m_Sin,sin,Settings::get_MaxHarmonics()*sizeof(float));
    memcpy(m_Cos,cos,Settings::get_MaxHarmonics()*sizeof(float));
}

EventDetector::EventDetector(int ch)
{
    m_Channel = ch;
    m_OutletTriggered = false;
    m_EventCounter = 0;
}
    
//void EventDetector::ProcessEvent(float rmsvalue, int t)
void EventDetector::ProcessEvent(float rmsvalue, float mv2, int under, int over)
{
    short gerafuga = 0;
    int tempofuga = 0;    
    
    //Thread::wait(500);//TimeDelay(t));
    //printf("%d time delay\n", TimeDelay(t));
    if (gerafuga && (m_Channel % 2 == 0) ){   
        /*         
        if (cont % MARCA == 0)
            printf("Envia Fuga %d %d\n", cont, TimeDelay(m_Channel));            
        cont++;
        */
        // Fuga
        m_OutletTriggered = true;  
        Capture::Stop();              
        //printf("Passou Stop\n");
        //CommTCP::RequestAcom();
        OnTrigger(rmsvalue, mv2, under, over, 0);       //TODO: must change the parameter of this function call
        //printf("Passou OnTriger\n");        
        Capture::Start();
        //printf("Passou Start\n");
        m_EventCounter = 0;

        Thread::wait(2);
        // Termino
        /*
        if (cont % MARCA == 0)
            printf("Envia Termino\n");
        */
        m_OutletTriggered = false;
        Capture::Stop();
        //printf("Passou Stop\n");
        OnTrigger(rmsvalue, mv2, under, over, 0);//TODO: must change the parameter of this function call
        //printf("Passou onTrigger\n");
        Capture::Start();
        //printf("Passou Start\n");
        m_EventCounter = 0;
            
        Thread::wait(2);
    }
    else{
        /*
        unsigned short int buf[NUMBER_OF_SAMPLES];
        Capture::CopyBuffer(m_Channel,buf);
        if ( (rmsvalue > 200) && (m_Channel == 0) ){
            for(int y=0; y< 256; y++)
                printf("%d*",buf
                [y]);
            printf("\n");
        }
        */    
        if(rmsvalue > Settings::get_Limit(m_Channel))
        {
            if(!m_OutletTriggered)
            {
                if(m_EventCounter < Settings::get_EventLimit())
                {
                    m_EventCounter++;
                }
                else
                {
                    //printf("Deu evento de liga ou Fuga\n");
                    if (m_Channel % 2 ==  1) // Canais impares sao de diferencial
                        m_tempo.start();
                    m_OutletTriggered = true;  
                    Capture::Stop();              
                    OnTrigger(rmsvalue, mv2, under, over, 0); //TODO: must change the parameter of this function call
                    //CommTCP::RequestAcom();
                    //zzz
                    Capture::Start();
                    m_EventCounter = 0;
                }
            }
            else
                m_EventCounter = 0;
        }
        else
        {
            if(m_OutletTriggered)
            {
                if(m_EventCounter < Settings::get_EventLimit())
                {
                    m_EventCounter++;
                }
                else
                {                    
                    //printf("Terminou evento de liga ou Fuga\n");
                    if (m_Channel % 2 ==  1){ // Canais impares sao de diferencial
                        //m_tempo.stop();
                        tempofuga = (int) (Settings::get_EventLimit() * UMCICLO) + m_tempo.read_ms();
                        //printf("Limite %d\n", (int) (Settings::get_EventLimit() * UMCICLO));
                        m_tempo.reset();
                    }
                    else
                        tempofuga = 0;
                    m_OutletTriggered = false;
                    Capture::Stop();
                    OnTrigger(rmsvalue, mv2, under, over, tempofuga);//TODO: must change the parameter of this function call
                    //printf("===> contliga %d contdesliga %d\n", contliga, contdesl);
                    //zzz
                    Capture::Start();                    
                    m_EventCounter = 0;
                }
            }
            else
                m_EventCounter = 0;
        }
    } // Final gerafuga
}
            
void EventDetector::ShowValues(CaptureEvent* e)
{        
    printf("RFID: %s\n", e->get_RFID());
    printf("type: %d\n", e->get_Type());    
    printf("OutletNr: %d\n", e->get_OutletNumber());
    printf("MeanValue: %f\n", e->get_MeanValue());
    printf("MV2: %f\n", e->get_MV2());
    printf("RMSValue: %f\n", e->get_RMSValue());
    printf("Underflow: %d\n", e->get_Under());
    printf("Overflow: %d\n", e->get_Over());
    printf("Gain: %f\n", e->get_Gain());
    printf("Offset: %d\n", e->get_Offset());
    printf("Duration: %d\n", e->get_Duration());
    
    int i;
    for(i=0;i<12;i++)
    {
        printf("Harm %d Sen %f Cos %f\n ", i, e->get_SineValue(i), e->get_CossineValue(i));
    }
    
}

//void EventDetector::OnTrigger(float rmsvalue)
void EventDetector::OnTrigger(float rmsvalue, float mv2, int under, int over, int duration)
{
    SendMessage(0,rmsvalue, mv2, under, over, duration);
    //printf("Ontrigger::Enviou mensagem\n");
    /*
    if(m_OutletTriggered)
    {
        for(int i=0;i<Settings::get_MaxChannels();i++)
        {
            //Thread::wait(300);
            if(i != m_Channel){
                //printf("Ontrigger::Enviou acompanhamento %d\n", i);
                get_Detector(i).ExternalTrigger();
            }
        }
        //printf("Ontrigger::Enviou acompanhamentos %d\n");
    }
    */
}

void EventDetector::ExternalTrigger()
{
    // Ajustar valores de mv2, under, over e duration na chamada!!!
    SendMessage(1, 0, 0, 0, 0, 0);
}

//void EventDetector::SendMessage(int ext,float rmsvalue)
void EventDetector::SendMessage(int ext, float rmsvalue, float mv2, int under, int over, int duration)
{       
    //printf("Chegou SendMessage\n");
    //Here we must alloc a CaptureEvent object from mailbox pool,
    CaptureEvent* event = GetMailbox().alloc();
    //printf("Capturou evento\n");
    //then initialize the object properly
    
    unsigned short int buf[NUMBER_OF_SAMPLES];
    Capture::CopyBuffer(m_Channel,buf);
    
    if(ext)
    {
        rmsvalue = 0;//SignalProcessor::CalculateRMS(buf,m_Channel);
    }
    
    float seno[NUMBER_OF_HARMONICS+1],coss[NUMBER_OF_HARMONICS+1],mv;
    //SignalProcessor::CalculateFFT(buf,sen,cos,&mv,1);
        
    int type=0,outlet_number=0, aux=0;
    aux = Settings::get_OutletNumber(m_Channel);
    outlet_number = Settings::get_Outlet(aux);
    
    //Temporario - Sem leitor de RFID    
    char rfid[9] = "1234560";
    rfid[7] = (char)outlet_number + '0';
    
    // Com leitor de RFID
    /*
    //send hitag request
    //capture hitag response
    //printf("OUTLET=%d\n",outlet_index+1);
    
    if(m_OutletTriggered)
        Capture::ReadRFID(outlet_index+1,m_RFID);
    */
    
           
    if(Settings::get_Purpose(m_Channel) == 'p') // phase channel 
    {
        if(ext!=0)
            type = 3;
        else
        {
            if(m_OutletTriggered)
                type = 4;                           // power on event
            else
                type = 5;                           // power off event
        }
    }
    if(Settings::get_Purpose(m_Channel) == 'd') // diferential channel (leakage)
    {
        if(ext!=0)
            type = 2;
        else
        {
            if(m_OutletTriggered)
                type = 1;                           // start leakage event
            else
                type = 6;                           // stop leakage event
        }
    }
    
    
    if (type == 1 || type == 2 || type == 4) // Calula FFT s nos eventos de fuga, acompanhamento de fuga (diferencial) e liga
        SignalProcessor::CalculateFFT(buf,seno,coss,&mv,1, m_Channel);
        /*
        for(int y=0; y < 12; y++)
            printf("[%d] sen %f cos %f\n", y, seno[y], coss[y]);
        */
    else
        for(int i=0; i < Settings::get_MaxHarmonics(); i++)
            seno[i] = coss[i] = 0;                         
    
    //event->Setup(rfid,type,outlet_number,mv,rmsvalue,Settings::get_Gain(m_Channel),Settings::get_Offset(m_Channel),seno,coss);
    
    
    event->Setup(rfid,type,outlet_number,mv,mv2, rmsvalue,under, over, Settings::get_Gain(m_Channel),Settings::get_Offset(m_Channel),duration, seno,coss);
                
    //printf("\n\nDuration: %d\n\n", duration);
    ShowValues(event);       
           
    //and finally place the object in the mailbox queue.
    //GetMailbox().put(event);
    //printf("Deu put no evento no mailBox\n");
}

int EventDetector::TimeDelay(int t){    
    switch (t){
        case 0: return 300;
        case 1: return 250;
        case 2: return 200;
        case 3: return 250;
        case 4: return 200;
        default: return 150; 
    }
}
