/*
 * CommTCP.cpp
 *
 *  Created on: 07/07/2013
 *      Author: Rebonatto
 */
#include "CommTCP.h"
#include "EventDetector.h"

void CommTCP::CommTCP_Thread(void const *arg)
{
    char buffer[5];
    int ret,i, r;    
    int cont = 0;
    TCPSocketServer ServerSocket;    
        
    ServerSocket.bind(Settings::get_PortTCP());    
    ServerSocket.listen();        
    printf("TCP Thread starting...\r\n");    
//    printf("ServerSocket %s:%d\n", get_address(), get_port());    
        
    while(1){        
        TCPSocketConnection sock;
        for(i=0; i < Settings::get_MaxTries(); i++){
            printf("Aguarda Conexao\n");
            r = ServerSocket.accept(sock);                
            if (r == 0) //Accept Ok
                break;
            else{
                printf("Error in Acceppt\n");
                wait_ms(Settings::get_DelayTry());
            }
        }
        //sock.set_blocking(true, 1500);    
    
        //printf("Conected %d at %s\n", r, sock.get_address());
        for(i=0; i < Settings::get_MaxTries(); i++){
            r = sock.receive(buffer, sizeof(buffer));
            if (r != -1) // Receive Ok
                break;
            else{
                printf("Erro na recepcao do Socket TCP\n");
                wait_ms(Settings::get_DelayTry());
            }
            buffer[ret] = '\0';
        }
        if (cont % 60 == 0)
            printf("Recebida conexao %d msg TCP: %d chars: *%s*\n", cont++, ret, buffer);
        
        //printf("Received %d chars:\n*%s*\n", ret, buffer);
        sock.close();        
        SendAcom(0,0);
        
    }
}

void CommTCP::RequestAcom(){
    // Metodo para solicitar os acompanhamentos
    char msg[] = "3;-1";
    TCPSocketConnection s[NEIGHBORS];
    int escritos, i;
    //TCPSocketConnection s[NEIGHBORS];
        
    /*
        Formato das mensagens de requisicao
        Tipo ; Tomada
        Tipos: 1 Solicitacao de fase
               2 Solicitacao de diferencial
               3 Acompanhamento (manda fase e diferencial)
        Tomada: Numero da tomada
                -1 (zero) quando de todas as tomadas
    */    
    /*Timer t;
    //t.start();

    for(i=0;i<Settings::get_NumNeighbors();i++){
        s[i].connect(Settings::get_Neighbor(i), Settings::get_PortTCP());   
    }          
    //t.stop();
    //printf("The time taken in connection was %d useconds\n", t.read_us());
    */
    for(i=0; i< Settings::get_NumNeighbors(); i++){    
        //talvez verificar se o socket est conectado. Se no estiver, destruir objeto e conectar
        TCPSocketConnection sock;
        sock.connect(Settings::get_Neighbor(i), Settings::get_PortTCP());        
        //escritos = Settings::get_Socket(i).send_all(msg, sizeof(msg)-1);
        //printf("Socket %d\n",s[i].is_connected());
        //Timer t1;
        //t1.start();
        escritos = sock.send_all(msg, strlen(msg));
        wait_ms(100);
        if(escritos != strlen(msg)){
            printf("Erro ao enviar mensagem para vizinho\n");
            break;
        }
        //t1.stop();
        //printf("The time taken in send was %d useconds\n", t1.read_us());

        sock.close();        
        
    }                    
}

void CommTCP::SendAcom(int tipo,int tomada){
    // Aqui chama a funço para enviar um acompanhamento
    for(int i=0;i<Settings::get_MaxChannels();i++)
    {
        EventDetector::get_Detector(i).ExternalTrigger();
    }
}

